
#ifndef __EBMEXPR_H__
#define __EBMEXPR_H__

#include  <list> 
#include  "Ebm.h"


class Ebm;

class EbmExpr : public Ebm {
  private:
             OperatorType     _operator;  // operateur de ce noeud
             std::list<Ebm*>  _operands;  // pointeurs sur les operandes 
  public:
                              EbmExpr     ( OperatorType, std::list<Ebm*>& operands );
    virtual                  ~EbmExpr     ();
    static   EbmExpr*         Not         ( Ebm* );
    static   EbmExpr*         Or          ( Ebm*, Ebm* );
    static   EbmExpr*         Or          ( Ebm*, Ebm*, Ebm* );
    static   EbmExpr*         Or          ( Ebm*, Ebm*, Ebm*, Ebm* );
    static   EbmExpr*         Xor         ( Ebm*, Ebm* );
    static   EbmExpr*         Xor         ( Ebm*, Ebm*, Ebm* );
    static   EbmExpr*         Xor         ( Ebm*, Ebm*, Ebm*, Ebm* );
    static   EbmExpr*         And         ( Ebm*, Ebm* );
    static   EbmExpr*         And         ( Ebm*, Ebm*, Ebm* );
    static   EbmExpr*         And         ( Ebm*, Ebm*, Ebm*, Ebm* );
  public:
    virtual  Ebm::Type        getType     ();
    inline   OperatorType     getOperator ();
    inline   std::list<Ebm*>& getOperands ();
};


inline Ebm::OperatorType  EbmExpr::getOperator () { return _operator; }
inline std::list<Ebm*>&   EbmExpr::getOperands () { return _operands; }


#endif  // __EBMEXPR_H__

