
#ifndef  __EVENT_H__
#define  __EVENT_H__

#include  "Signal.h"
#include  "Scheduler.h"


class Event {
  private:
    Signal*     _signal;
    LogicValue  _value;
    Date        _date;
  public:
    inline              Event             ( Signal*, LogicValue, Date& );
    inline  Signal*     getSignal         ();
    inline  LogicValue  getValue          ();
    inline  Date&       getDate           ();
    inline  void        updateSignalValue ();
};


// Event inline functions.
inline  Event::Event ( Signal* signal, LogicValue value, Date& date )
  : _signal(signal)
  , _value (value)
  , _date  (date)
{ }

inline  Signal*     Event::getSignal         () { return _signal; }
inline  LogicValue  Event::getValue          () { return _value; }
inline  Date&       Event::getDate           () { return _date; }
inline  void        Event::updateSignalValue () { _signal->setValue(_value); }


#endif  // __EVENT_H__

