#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>
#include "main.h"
#include "count.h"

struct mainarg_s MAINARG;

void usage (char *command)
{
    printf ("\nStatistique Diverses\n");
    printf ("Usage 	: %s [-v] [-o OutFile] InFile\n", command);
    printf ("-v        	 verbose mode\n");
    printf ("-o OutFile  output file (stdout by default)\n\n");
    exit (EXIT_FAILURE);
}

void getarg (int argc, char **argv)
{
    extern char *optarg;
    extern int optind;
    char option;

    MAINARG.OUTPUTFILE = NULL;
    while ((option = getopt (argc, argv, "vo:")) != EOF)
        switch (option)
        {
        case 'v':
            MAINARG.VERBOSE = 1;
            fprintf (stderr, "Verbose mode\n");
            break;

        case 'o':
            if (MAINARG.VERBOSE)
                fprintf (stderr, "Fichier de sortie : %s\n", optarg);

            MAINARG.OUTPUTFILE = fopen (optarg, "w");
            if (MAINARG.OUTPUTFILE == NULL)
            {
                fprintf (stderr, "%s: %s: \n", argv[0], optarg);
                perror ("fopen");
                exit (EXIT_FAILURE);
            }
            break;

        case '?':
        default:
            usage (argv[0]);
        }
    if ((optind + 1) != argc)
    {
        usage (argv[0]);
    }
    else
    {
        if (MAINARG.VERBOSE)
            fprintf (stderr, "Fichier d'entre : %s\n", argv[optind]);

        MAINARG.INFILE = fopen (argv[optind], "r");
        if (MAINARG.INFILE == NULL)
        {
            fprintf (stderr, "%s: %s ", argv[0], argv[optind]);
            perror ("fopen");
            exit (EXIT_FAILURE);
        }
        if (MAINARG.OUTPUTFILE == NULL)
            MAINARG.OUTPUTFILE = stdout;
    }
}

int main (int argc, char **argv)
{
    getarg (argc, argv);
    count (MAINARG.INFILE);
    fclose (MAINARG.OUTPUTFILE);
    return EXIT_SUCCESS;
}
