#include <stdio.h>
#include <string.h>
#include "dico.h"
#include "count.h"


/*********************************************************************
  Cette fonction retourne successivement tous les mots d'un 
  fichier. Un mot est une squence de caractres qui se termine
  par un espace, une tabulation ou un retour chariot.
  Paramtre :
      infile : pointe sur le fichier dj ouvert
  Retour :
      La fonction rend un pointeur sur la chaine reprsentant 
      le mot et rend galement dans *numero le numro de ligne 
      o se trouve le mot
*********************************************************************/
static char *token(FILE * infile, int *numero)
{
    static char buffer[1024];
    static char *current_token = NULL;
    static unsigned numline = 1;
    const char *delim = " \t\n";
    do
    {
        if (current_token == NULL)
        {
            if (fgets (buffer, sizeof (buffer), infile) == NULL)
                return NULL;
            current_token = strtok (buffer, delim);
            numline++;
        }
        else
            current_token = strtok (NULL, delim);
    }
    while (current_token == NULL);
    *numero = numline;
    return current_token;
}

/***********************************************************************
  cette fonction affiche les rsultats du comptage
  accumuls dan le dictionnaire root              
************************************************************************/
static void result_count(dico_root_t *root)
{
    dico_iterator_t *iter = dico_iterator(root);
    dico_item_t *item;

    for (item = dico_first(iter) ; item ; item = dico_next(iter)) {
             printf ("%20s : %d occurences\n", item->KEY, item->COUNT);
    }
}

/************************************************************************
  La fonction count compte le nombre de mots total d'un fichier 
  ainsi que le nombre d'occurences de chaque mots.
  parametre:
      infile : pointe sur le fichier dj ouvert
  retour:
      La fonction ne renvoie rien.
      Elle affiche le resultat de son comptage
************************************************************************/
void count (FILE * infile)
{
char 		*tok;
int 		numero;
dico_item_t	*item;
int 		nb_mots = 0;
dico_root_t	*dico = dico_create(100);

while ((tok = token(infile, &numero))) {
        item = dico_get (dico, tok);
	item->COUNT++;
	nb_mots++;
}

printf ("le fichier contient %d mots \n\n", nb_mots);
result_count(dico);
}
