#ifndef _DICO_H_
#define _DICO_H_

/********************************************************************
  structure dfinissant un item du dictionnaire
  Un item est form d'un couple (KEY,COUNT) plus un pointeur NEXT
  permettant de chainer les items ayant le meme index de hachage.
  Cette structure a un encombrement variable en mmoire,
  puisque la longueur de la chaine de caractres KEY est variable.
*********************************************************************/
typedef struct dico_item_s
{
    struct dico_item_s 	*NEXT;  /* pointeur sur l'item suivant */
    unsigned int	COUNT;  /* valeur associe  l'item */
    char 		KEY[];  /* tableau flexible contenant la cl */
} dico_item_t;

/********************************************************************
  structure dfinissant un dictionnaire
*********************************************************************/
typedef struct dico_root_s
{
    unsigned int	SIZE;	/* nombre de cases du tableau */
    dico_item_t		**HTAB;	/* adresse du tableau de pointeurs */
} dico_root_t;


/********************************************************************
  structure dfinissant un itrateur permettant de parcourir 
  simplement tous les items d'un dictionnaire.
*********************************************************************/
typedef struct dico_iterator_s
{
    dico_root_t         *ROOT;
    unsigned            INDEX;
    dico_item_t         *ITEM;
} dico_iterator_t;

/********************************************************************
  fonctions externes
********************************************************************/

extern dico_root_t *dico_create(unsigned int size);
extern dico_item_t *dico_get(dico_root_t *root, char *key);
extern dico_iterator_t *dico_iterator(dico_root_t *root);
extern dico_item_t *dico_first(dico_iterator_t *iter);
extern dico_item_t *dico_next(dico_iterator_t *iter);

#endif
