/*
 * Gestion de la structure ABL (Arbres binaires Lisp-Like)
 * -----------------------------------------------------------------------------
 * Creation [10 mai 2006] [Alain Greiner, Franck Wajsb"urt]
 * -----------------------------------------------------------------------------
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <bip.h>
#include <var.h>

/*
 * Fonctions et Variables <static> (locales au fichier courant)
 * -----------------------------------------------------------------------------
 */

/* 
 * allocation d'une zone de memoire de <size> octets dans le tas 
 * avec verification du pointeur retourne par malloc. 
 * s'il n'y a plus de memoire, on affiche le message <mess> et on sort du
 * programme.
 * Cette fonction est <static>, c-a-d utilisable uniquement dans ce fichier
 */
static void *safe_malloc (size_t size, const char *mess)
{
    void *zone = malloc (size);
    if (zone == NULL)
    {
        perror (mess);
        exit (1);
    }
    return zone;
}

static bip_t *free_bip_list;    /* pointe vers la liste de bipointeurs libres */

/*
 * Fonctions et Variables <extern> (utilisables par tous)
 * -----------------------------------------------------------------------------
 */

/* representation ascii des operateurs */
char *op_name[] = { "NOT", "OR", "AND", "XOR" };

/* creation et initialisation d'un bipointeur (commentaire dans bip.h) */
bip_t *cons_bip (bip_t * next, void *data)
{
    bip_t *new;
    if (free_bip_list)
    {
        new = free_bip_list;
        free_bip_list = free_bip_list->NEXT;
    }
    else
        new = safe_malloc (sizeof (bip_t), "cons_bip");

    new->DATA = data;
    new->NEXT = next;
    return new;
}

/* liberation d'un bipointeur (commentaire dans bip.h) */
void free_bip (bip_t * bip)
{
    bip->NEXT = free_bip_list;
    free_bip_list = bip;
}

void display_abl (bip_t * p)
{
    printf ("Affichage d'une abl\n");
}

