#include <stdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <stdarg.h>
#include <var.h>
#include <bip.h>
#include <parse_abl.h>

/*
 * verifie que <cond> est  1
 * si oui: on sort sans rien faire
 * si non: on affiche le message <mess> et on sort
 * Cette fonction est <static>, c-a-d utilisable uniquement dans ce fichier
 * exemple: assert ((1==0),"ligne %d: toujours faux %s", 46, "evidemment")
 */
static void assert (unsigned cond, const char *mess, ...)
{
    va_list arg;
    va_start(arg, mess);
    if (cond == 0)
    {
        fprintf (stderr, "PARSER abl : ");
        vfprintf (stderr, mess , arg);
        fprintf (stderr, "\n");
        exit (1); 
    }
}

/*
 * lexer ecrit directement en c (pas d'utilisation de flex)
 * Toutefois les noms de fonctions, de variable et leur comportement 
 * correspondent  ceux attendus par bison. c-a-d.: abllex rend un numro 
 * de token dfinit par yacc et affecte la variable abllval.
 */

#define ABL_BUF_SIZE 16384       /* taille maximale d'un token */
static union 
{
    char * s;
}   abllval;
static char *ablin;              /* ptr sur le caractere courant a parser */
static char *ablin_start;        /* ptr sur le buffer a parser */
static char abltext[ABL_BUF_SIZE];/* buffer du token */
static int ablleng;              /* taille du token courant */
enum { T_AND = 257, T_OR, T_XOR, T_NOT, T_VAR };
static int abllex (void)
{
    ablleng = 0;                 /* on remet l'index de abltext  0 */
    assert ((ablin != NULL), "parse_abl: chaine vide");
    if (*ablin == 0)
        return 0;               /* fin de chaine */
    while (isspace (*(ablin++))); /* passe les espaces de debut */
    if (*(--ablin) == 0)
        return 0;               /* fin de chaine */

    /* si [^a-zA-Z0-9_] on sort le code ascii tel quel */
    if (!(isalnum (*ablin) || (*ablin == '_')))
    {
        abltext[ablleng++] = *(ablin++);
        abltext[ablleng] = '\0';
        return abltext[0];
    }

    /* on extrait les mots dfinis par [a-zA-Z0-9_]+ */
    for (ablleng = 0;
         (isalnum (*ablin)||(*ablin == '_')) && (ablleng < (ABL_BUF_SIZE + 1));
         abltext[ablleng++] = *(ablin++));
    abltext[ablleng] = '\0';

    /* detection des mots cle du langage */
    if (strcasecmp (abltext, "and") == 0)
        return T_AND;
    if (strcasecmp (abltext, "or") == 0)
        return T_OR;
    if (strcasecmp (abltext, "xor") == 0)
        return T_XOR;
    if (strcasecmp (abltext, "not") == 0)
        return T_NOT;
    abllval.s = abltext;
    return T_VAR;
}

enum ETAT_PASER { INIT, DOWN, UP };
static bip_t *ablparse (int etat)
{
    bip_t *tmp;
    unsigned tok = abllex ();
    switch (etat)
    {
    case INIT:
        /* on attend un operateur ou une variable */
        switch (tok)
        {
        case T_VAR:
            return cons_bip (NULL, get_var_name (abllval.s));
        case T_AND:
            return cons_bip (ablparse (DOWN), (void *) AND);
        case T_OR:
            return cons_bip (ablparse (DOWN), (void *) OR);
        case T_XOR:
            return cons_bip (ablparse (DOWN), (void *) XOR);
        case T_NOT:
            return cons_bip (ablparse (DOWN), (void *) NOT);
        default:
            assert (0, "%d : operateur ou variable attendu : %s",
                    ablin-ablin_start,abllval.s);
        }
    case DOWN:
        /* on attend une parenthese ouvrante et rien d'autre */
        switch (tok)
        {
        case '(':
            return ablparse (UP);
        default:
            assert (0, "%d : parenthese ouvrante attendue");
        }
    case UP:
        /* on attend un operateur, une variable ou une parenthese fermante */
        switch (tok)
        {
        case ')':
            return NULL;
        case T_VAR:
            return cons_bip (ablparse (UP), 
                   cons_bip( NULL,  get_var_name (abllval.s)));
        case T_AND:
            tmp = cons_bip (ablparse (DOWN), (void *) AND);
            return cons_bip (ablparse (UP), tmp);
        case T_OR:
            tmp = cons_bip (ablparse (DOWN), (void *) OR);
            return cons_bip (ablparse (UP), tmp);
        case T_XOR:
            tmp = cons_bip (ablparse (DOWN), (void *) XOR);
            return cons_bip (ablparse (UP), tmp);
        case T_NOT:
            tmp = cons_bip (ablparse (DOWN), (void *) NOT);
            return cons_bip (ablparse (UP), tmp);
        default:
            assert (0, "%d : operateur ou variable attendu: %s",
                    ablin-ablin_start,abllval.s);
        }
    }
    /* parce gcc ne voit pas que assert est fatal pour le programme */
    return NULL;
}


/* creation d'un abl a partir d'une chaine (commentaire parse_abl.h) */
bip_t *parse_abl (char *expr)
{
    ablin_start = expr;
    ablin = expr;
    return ablparse(INIT);
}

