#ifndef _BIP_H_                 /* protege des inclusions multiples */
#define _BIP_H_
/*
 * Gestion de la structure ABL (Arbres binaires Lisp-Like)
 * -----------------------------------------------------------------------------
 * Creation [10 mai 2006] [Alain Greiner, Franck Wajsb"urt]
 * -----------------------------------------------------------------------------
 * Les ABL (Abres Binaires Lisp-Like) sont utilises pour representer des 
 * expressions Booleennes multi-niveaux (c'est a dire des expressions Booleennes
 * prefixees pouvant comporter plusieurs niveaux dimbrication de parenthesage).
 * Avec cette technique, une expression Booleenne est representee comme une 
 * liste chainee de bipointeurs. Le premier element de la liste definit 
 * l'operateur (les 4 operateurs utilises sont NOT, OR, AND et XOR).
 * -----------------------------------------------------------------------------
 */


/*
 * Structures de donnees
 * -----------------------------------------------------------------------------
 */

/* definition des operateur Booleen */
typedef enum op_t
{
    NOT, OR, AND, XOR
} op_t;

/* representation ascii des operateurs */
extern char *op_name[];

/* definition d'un noeud d'arbre ABL */
typedef struct bip_t
{
    /* pointeur vers le successeur dans la liste */
    struct bip_t *NEXT;
    /* DATA peut contenir 3 types de donnee 
     * 1) bip_t * : ptr vers un arbre ABL 
     * 2) var_t * : ptr vers une variable 
     * 3) op_t    : un numero d'operateur */
    void *DATA;
} bip_t;


/*
 * Fonctions
 * -----------------------------------------------------------------------------
 */

/*
 * Creation et initialisation d'un bipointeur 
 * avant de demander une nouvelle zone dans le tas, on regarde
 * si un bipointeur precedemement alloue n'aurait pas ete libere.
 */
extern bip_t *cons_bip (bip_t * next, void *data);

/* 
 * liberation d'un bipointeur 
 * Cette fonction ne libere pas vraiment la memoire mais place le bipointeur
 * donne en argument dans une liste de bipointeurs libres. Cette liste est 
 * utilise par cons_bip
 */
extern void free_bip (bip_t * bip);

/* 
 * affichage formate d'une abl
 */
extern void display_abl (bip_t * bip);

#endif
