#ifndef _PARSE_ABL_H            /* protege des inclusions multiples */
#define _PARSE_ABL_H
/*
 * Parser de la structure ABL (Arbres binaires Lisp-Like)
 * -----------------------------------------------------------------------------
 * Creation [14 mai 2006] [Alain Greiner, Franck Wajsb"urt]
 * -----------------------------------------------------------------------------
 * Les ABL (Abres Binaires Lisp-Like) sont utilises pour representer des 
 * expressions Booleennes multi-niveaux (c'est a dire des expressions Booleennes
 * prefixees pouvant comporter plusieurs niveaux dimbrication de parenthesage).
 * Avec cette technique, une expression Booleenne est representee comme une 
 * liste chainee de bipointeurs. Le premier element de la liste definit 
 * l'operateur (les 4 operateurs utilises sont NOT, OR, AND et XOR).
 * -----------------------------------------------------------------------------
 */

#include <bip.h>

/*
 * parse_abl() prend en entree une chaine de caracteres decrivant une
 * expression Booleenne prefixee possedant un nombre quelconque de niveaux
 * de parenthesage.  Elle construit en memoire larbre ABL representant
 * cette expression Booleenne et renvoie un pointeur sur le bipointeur
 * correspondant a la racine.  Attention: Cette fonction n'accepte que les
 * expressions Booleennes prefixees. Les seuls operateurs acceptes sont NOT,
 * OR, AND et XOR. Elle affiche un message derreur en cas derreur de syntaxe,
 * ou si elle rencontre un nom de variable non declaree prealablement.
 */
extern bip_t *parse_abl (char *expr);

#endif
