#ifndef _VAR_H_                 /* protege des inclusions multiples */
#define _VAR_H_
/*
 * Gestion des variables pour la structure ABL (Arbres binaires Lisp-Like)
 * et la structure robdd (Reduced Oriented Binary Decision Diagram)
 * -----------------------------------------------------------------------------
 * Creation [10 mai 2006] [Alain Greiner, Franck Wajsb"urt]
 * -----------------------------------------------------------------------------
 * Les ABL (Abres Binaires Lisp-Like) sont utilises pour representer des 
 * expressions Booleennes multi-niveaux (c'est a dire des expressions Booleennes
 * prefixees pouvant comporter plusieurs niveaux dimbrication de parenthesage).
 * Avec cette technique, une expression Booleenne est representee comme une 
 * liste chainee de bipointeurs. Le premier element de la liste definit 
 * l'operateur (les 4 operateurs utilises sont NOT, OR, AND et XOR).
 *
 * Les ROBDD (Reduced Ordered Binary Decision Diagram) sont utiliss pour
 * reprsenter de faon compacte une ou plusieurs fonctions Boolennes,
 * partageant le mme support (cest  dire dpendant dun mme ensemble de
 * variables Boolennes). Pour un ordre donn des variables constituant
 * le support, cette reprsentation est canonique : A chaque fonction
 * Boolenne est associ un unique graphe orient acyclique (DAG). Le graphe
 * tant acyclique, chaque noeud BDD dfinit un sous-graphe dont il est
 * la racine. Par consquent, chaque noeud BDD correspond  une fonction
 * Boolenne particulire. On utilise le fait que les variables Boolennes
 * constituant le support sont ordonnes pour identifier ces variables par
 * leur index.
 * -----------------------------------------------------------------------------
 */


/*
 * Parametres
 * -----------------------------------------------------------------------------
 */

/* 
 * NB_VAR definit le nombre maximum de variables souhaitees
 * ce nombre doit etre un nombre premier, par exemple:
 * 101, 547, 1061, 3299, 5309, 10337, 20143, 32423, 43151, 52223, 76463, 101747 
 */
#define NB_VAR 101


/*
 * Structures de donnees
 * -----------------------------------------------------------------------------
 */

/* definition d'une variable Booleenne */
typedef struct var_t
{
    /* son nom (unique) */
    char *NAME;
    /* son numero identifiant (unique) */
    unsigned INDEX;
    /* sa valeur logique */
    unsigned VALUE;
} var_t;

/*
 * Fonctions
 * -----------------------------------------------------------------------------
 */

/* 
 * creation de la variable (name, index) initialise avec value
 * verifie:
 * - l'unicite de name
 * - l'unicite d'index
 * - la validite de valeur
 * rend:
 * - un pointeur vers une nouvelle variable
 * - sort du programme en cas d'erreur
 */
extern var_t *cons_var (char *name, unsigned index, unsigned value);

/*
 * Les variables sont rangees dans un dictionnaire qui permet de retrouver 
 * rapidement une variable. Les deux fonctions get_var_index et get_var_name 
 * renvoient un pointeur vers la variable designee respectivement par son index
 * ou par son nom. Ces fonctions affichent un message d'erreur si la
 * variable recherche ni'existe pas.
 */
extern var_t *get_var_index (unsigned index);
extern var_t *get_var_name (char *name);

#endif
