
;  ### -------------------------------------------------------------- ###
;  # file	: std.x							#
;  # date	: Sep  2 2009						#
;  # descr.	: functional test for Mips R3000			#
;  ### -------------------------------------------------------------- ###

	;  ### ------------------------------------------------------ ###
	;  #   exception data section					#
	;  ### ------------------------------------------------------ ###

			.kdata
			.align 2

			.globl	active_pcs_context
			.globl	pending_pcs_context

active_pcs_context  :	.word	0
pending_pcs_context :	.word	0
free_space          :	.word	kernel_data_end
free_pcs_stack      :	.word	user_stack_begin

thread_context_size	.equ	4*39
thread_stack_size	.equ	1024

	;  ### ------------------------------------------------------ ###
	;  #   exception text section					#
	;  #     - no reorder						#
	;  ### ------------------------------------------------------ ###

			.excep
			.set	noreorder

	;  ### ------------------------------------------------------ ###
	;  #   constants						#
	;  ### ------------------------------------------------------ ###

exccode_mask		.equ	0x003c

unexpected_exc_code	.equ	0x04
simulation_exit_code	.equ	0x10

	;  ### ------------------------------------------------------ ###
	;  #   peripherals address					#
	;  ### ------------------------------------------------------ ###

terminal_adr		.equ	kernel_term_begin
sim_controller		.equ	kernel_cntl_begin
timer_adr		.equ	kernel_timer_begin

timer_config_offset	.equ	3*4

timer_config_start_mask	.equ	0x0001
timer_config_stop_mask	.equ	0x0000ffff & ~timer_config_start_mask

	;  ### ------------------------------------------------------ ###
	;  #   exception and interrupt handler				#
	;  ### ------------------------------------------------------ ###

_excepetion_handler :

	;  ### ------------------------------------------------------ ###
	;  #   stop the timer						#
	;  ### ------------------------------------------------------ ###

_exc_stop_timer :
			la	r26, timer_adr

			lw	r27, timer_config_offset (r26)
			andi	r27, r27, timer_config_stop_mask
			sw	r27, timer_config_offset (r26)

	;  ### ------------------------------------------------------ ###
	;  #   jump to the sub-routines that handle each particular	#
	;  # exception cause						#
	;  ### ------------------------------------------------------ ###

			la	r26,      exc_causes_table

			mfc0	r27,      cause
			andi	r27, r27, exccode_mask

			addu	r26, r26, r27
			lw	r27, 0 (r26)

			jr	r27
			nop

	;  ### ------------------------------------------------------ ###
	;  #   exception return						#
	;  ### ------------------------------------------------------ ###

_exception_return :

	;  ### ------------------------------------------------------ ###
	;  #   stop the timer						#
	;  ### ------------------------------------------------------ ###

_exc_start_timer :
			la	r26, timer_adr

			lw	r27, timer_config_offset (r26)
			ori	r27, r27, timer_config_start_mask
			sw	r27, timer_config_offset (r26)

			eret

	;  ### ------------------------------------------------------ ###
	;  #   table of exception causes sub-routine address		#
	;  ### ------------------------------------------------------ ###

			.align	2
exc_causes_table :
			.word	_other_causes		;  0 : interrupts
			.word	_other_causes		;  1 : reserved
			.word	_other_causes		;  2 : reserved
			.word	_other_causes		;  3 : reserved
			.word	_other_causes		;  4 : load  adr error
			.word	_other_causes		;  5 : store adr error
			.word	_other_causes		;  6 : inst bus error
			.word	_other_causes		;  7 : data bus error
			.word	_syscall_cause		;  8 : syscall
			.word	_other_causes		;  9 : break
			.word	_other_causes		; 10 : illegal inst
			.word	_other_causes		; 11 : copro unusable
			.word	_other_causes		; 12 : overflow
			.word	_other_causes		; 13 : trap
			.word	_other_causes		; 14 : reserved
			.word	_other_causes		; 15 : reserved

	;  ### ------------------------------------------------------ ###
	;  #   table of syscall sub-routines address			#
	;  ### ------------------------------------------------------ ###

			.align	2
syscall_table :
			.word	_syscall_exit
			.word	_syscall_putchar
			.word	_syscall_puts
			.word	_syscall_fputs

	;  ### ------------------------------------------------------ ###
	;  #   jump to the appropriate syscall sub-routine		#
	;  ### ------------------------------------------------------ ###

_syscall_cause :
			la	r26, syscall_table
	
			addu	r26, r26, r2		; syscall number
			lw   	r27, 0 (r26)
			jr	r27
			nop

	;  ### ------------------------------------------------------ ###
	;  #   syscall exception return					#
	;  ### ------------------------------------------------------ ###

_syscall_return :
			mfc0	r27, epc
			addiu	r27, r27, 4
			mtc0	r27, epc

			j	_exception_return
			nop

	;  ### ------------------------------------------------------ ###
	;  #   syscall : exit						#
	;  ### ------------------------------------------------------ ###

_syscall_exit :
			ori	r26, r0 , simulation_exit_code
			la	r27,      sim_controller
			sb	r26, 0 (r27)

			j	_endless_loop
			nop

	;  ### ------------------------------------------------------ ###
	;  #   syscall : puts						#
	;  ### ------------------------------------------------------ ###

_syscall_puts :
			lb	r9 , 0 (r4 )
			la	r8 , terminal_adr
			beq	r9 , r0 , _puts_end_loop
			nop
_puts_loop :
			sb	r9 , 0 (r8 )
			lb	r9 , 1 (r4 )
			addiu	r4 , r4 , 1

			bne	r9 , r0 , _puts_loop
			nop

_puts_end_loop :
			ori	r9 , r0 , '\n'		; print '\n'
			sb	r9 , 0 (r8 )

			j	_syscall_return
			ori	r2 , r0 , 1

	;  ### ------------------------------------------------------ ###
	;  #   syscall : fputs						#
	;  ### ------------------------------------------------------ ###

_syscall_fputs :
			la	r8 , terminal_adr

			lb	r9 , 0 (r4 )
			beq	r9 , r0 , _fputs_end_loop
			nop
_fputs_loop :
			sb	r9 , 0 (r8 )
			lb	r9 , 1 (r4 )
			addiu	r4 , r4 , 1

			bne	r9 , r0 , _fputs_loop
			nop

_fputs_end_loop :
			j	_syscall_return
			ori	r2 , r0 , 1

	;  ### ------------------------------------------------------ ###
	;  #   syscall : putchar					#
	;  ### ------------------------------------------------------ ###

_syscall_putchar :
			la	r8 , terminal_adr
			sb	r4 , 0 (r8 )

			j	_syscall_return
			add	r2 , r4 , r0

	;  ### ------------------------------------------------------ ###
	;  #   other causes						#
	;  ### ------------------------------------------------------ ###

_other_causes :
			ori	r27, r0 , unexpected_exc_code
			la	r26,      sim_controller

			sb	r27, 0 (r26)
			j	_endless_loop
			nop

	;  ### ------------------------------------------------------ ###
	;  #   endless loop						#
	;  ### ------------------------------------------------------ ###

_endless_loop :
			j	_endless_loop
			nop
