
;  ###----------------------------------------------------------------###
;  # file	: std.r							#
;  # date	: Sep  2 2009						#
;  # descr.	: functional test for Mips-32				#
;  ###----------------------------------------------------------------###

	;  ###--------------------------------------------------------###
	;  #   reset section						#
	;  #     - no reorder						#
	;  ###--------------------------------------------------------###

			.reset
			.set	noreorder

	;  ###--------------------------------------------------------###
	;  #   initialization prgram (hardware RESET)			#
	;  ###--------------------------------------------------------###

user_status		.equ	0x0000ff15

reset_sw_int		.equ	0x00000000
user_stack		.equ	user_stack_begin
user_prog		.equ	_main

timer_adr		.equ	kernel_timer_begin
timer_countr_offset	.equ	0*4
timer_status_offset	.equ	1*4
timer_period_offset	.equ	2*4
timer_config_offset	.equ	3*4

timer_period_default	.equ	10000

timer_config_start_mask	.equ	0x0001
timer_config_inten_mask	.equ	0x0002
timer_config_enabl_mask	.equ	0x0003

	;  ### ------------------------------------------------------ ###
	;  #   initialization prgram (hardware RESET)			#
	;  ### ------------------------------------------------------ ###

_hardware_reset:

	;  ### ------------------------------------------------------ ###
	;  #   initialize coprocessor zero's registers			#
	;  ### ------------------------------------------------------ ###

			mtc0	r0 , count

			li	r27, excp_text_base
			mtc0	r27, ebase

			li	r27, user_status
			mtc0	r27, status

			la	r27, user_prog
			mtc0	r27, eepc

			li	r27, reset_sw_int
			mtc0	r27, cause

	;  ### ------------------------------------------------------ ###
	;  #   initialize timer						#
	;  ### ------------------------------------------------------ ###

			la	r26, timer_adr
			li	r27, timer_period_default
			sw	r27, timer_period_offset (r26)

			sw	r0 , timer_status_offset (r26)
			sw	r0 , timer_countr_offset (r26)

			ori	r27, r0 , timer_config_enabl_mask
			sw	r27, timer_config_offset (r26)
			
	;  ###--------------------------------------------------------###
	;  #   create the _main process					#
	;  #								#
	;  #     - a data structure should be created to hold the	#
	;  #       context of the _main program				#
	;  #     - r28 : initialized with the address of global		#
	;  #             variables					#
	;  #     - r29 : initialized with the stack address		#
	;  #     - r31 : initialized at 0x00000000			#
	;  ###--------------------------------------------------------###

			la	r29, user_stack		; user stack pointer

	;  ###--------------------------------------------------------###
	;  #   return from reset - jump to _main			#
	;  ###--------------------------------------------------------###

			eret				; return from reset

	;  ###--------------------------------------------------------###
	;  #   exception						#
	;  ###--------------------------------------------------------###

			.bexcep

unexpected_btx_code	.equ    0x08
sim_controller		.equ	kernel_cntl_begin

	;  ###--------------------------------------------------------###
	;  #   signaling bad execution					#
	;  ###--------------------------------------------------------###

_ex_it_handler :
_unexpected_ex :
			addiu	r26, r0 , unexpected_btx_code
			la	r27,      sim_controller
			j	_end_loop
			nop
_end_loop :
			sb	r26, 0 (r27)
			j	_end_loop
			nop
