#include <stdio.h>
#include <srl.h>
#include "mjpeg_tg_proto.h"

#include "jpeg.h"

static FILE *fi;

FUNC(tg) {

    fi = fopen(FILE_NAME, "r");
    if (! fi) {
        perror("fopen("FILE_NAME")");
        exit(1);
    }

    srl_mwmr_config(tg_ctrl, 0, 1);

    srl_mwmr_t output = SRL_GET_MWMR(output);

    while (1) {
        srl_log(DEBUG, "TG up and running...\n");
        uint8_t e[32];

        int r;
        r = fread(e, 1, 32, fi);
        if (r < 32) {
            fseek(fi, 0, SEEK_SET);
            fread(e + r, 1, 32-r, fi);
        }
        srl_mwmr_write(output, e, 1);
    }
}

/*
# Local Variables:
# tab-width: 4;
# c-basic-offset: 4;
# c-file-offsets:((innamespace . 0)(inline-open . 0));
# indent-tabs-mode: nil;
# End:
#
# vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
*/

