#!/usr/bin/env python

from dsx import *

# Declaration of all MWMR fifos
tg_demux    = Mwmr("tg_demux", 32 / 4, 8) # width (in words), depth
demux_vld   = Mwmr(...)
vld_iqzz    = Mwmr(...)
iqzz_idct   = Mwmr(...)
idct_libu   = Mwmr(...)
libu_ramdac = Mwmr(...)
huffman     = Mwmr(...)
quanti      = Mwmr(...)

tcg = Tcg('mjpeg',
    Task('tg', "mjpeg_tg",
          { 'output':tg_demux },
            defines = {'FILE_NAME':'"plan.mjpg"'}),
    Task('demux', "mjpeg_demux",
          { 'input':tg_demux,
            'output':demux_vld,
            'huffman':huffman,
            'quanti':quanti },
            defines = {'WIDTH':"48",
                       'HEIGHT':"48"}),
    Task('vld', ... )

    ...

    Task('ramdac', "mjpeg_ramdac",
          { 'input': libu_ramdac },
            defines = {'WIDTH':"48",
                       'HEIGHT':"48"}),
    )

tcg.generate(Posix())

