#include "srl.h"
#include <stdio.h>
#include "srl_endianness.h"
#include "mjpeg_ramdac_proto.h"

#include "jpeg.h" 

#include "ramdac_x11.h"

static uint8_t *frame_buffer;

#ifdef OUT_FILE_NAME
#define PRINT_TO_FILE 1
#define OUT_FILE_NAME "output.jpeg"
#endif


FUNC(ramdac) {
   #if PRINT_TO_FILE
      FILE *fi;

      fi = fopen(OUT_FILE_NAME, "w+");
      if (! fi) {
         perror("fopen("OUT_FILE_NAME")");
         exit(1);
      }
   #endif

   srl_mwmr_t input = SRL_GET_MWMR(input);

   frame_buffer = (uint8_t *) fb_init(WIDTH, HEIGHT);

   int32_t i;

   while (1) {

      for (i = 0; i < MAX_HEIGHT; i += 8) {
         srl_log_printf(TRACE, "copying line %d->%d\n", i, i + 7);
         srl_mwmr_read(input, &frame_buffer[i * MAX_WIDTH], 1); // (8 * MAX_WIDTH);

         #if PRINT_TO_FILE
            fwrite(&frame_buffer[i * MAX_WIDTH], (8 * MAX_WIDTH), 1 , fi);
         #endif

         fb_update();
      }
      srl_log(TRACE, "RAMDAC: display!\n");
   }
}

/*
# Local Variables:
# tab-width: 4;
# c-basic-offset: 4;
# c-file-offsets:((innamespace . 0)(inline-open . 0));
# indent-tabs-mode: nil;
# End:
#
# vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
*/


