/*
 *
 * SOCLIB_GPL_HEADER_BEGIN
 *
 * This file is part of SoCLib, GNU GPLv2.
 *
 * SoCLib is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * SOCLIB_GPL_HEADER_END
 *
 * Copyright (c) UPMC, Lip6, SoC
 *         Nicolas Pouillon <nipo@ssji.net>, 2006-2007
 *
 * Maintainers: nipo
 */

#include "system.h"

#include "../segmentation.h"

#include "../node/vci_uart/include/soclib/uart.h"
#include "soclib/timer.h"
#include "soclib/icu.h"
#include <stdio.h>

static const int period = 100000;
volatile static uint32_t cptms=0;
volatile static uint32_t irq_flag;

void irq_handler(int irq)
{
        uint32_t iv;
        uint32_t ti;
        uint32_t d;

        iv = soclib_io_get(
                base(ICU),
                ICU_IT_VECTOR);

        switch (iv)
        {
                case 0:
        		d=soclib_io_get(
                		base(UART),
                		UART_DATA);
        		printf("data received %d\n",d);
                        break;
                case 1:
                        cptms++;
                        cptms=cptms%10;


                        ti = soclib_io_get(
                                base(TIMER),
                                0*TIMER_SPAN+TIMER_VALUE);
                        soclib_io_set(
                                base(TIMER),
                                0*TIMER_SPAN+TIMER_RESETIRQ,
                                0);
                        irq_flag=1;
                        break;
        }
}

int main(void)
{
	uint32_t id;
	uint32_t first = 0;
	uint32_t sensor = 0;

        irq_flag=0;

        set_irq_handler(irq_handler);

	id = soclib_io_get(
			   base(UART),
			   UART_ID);


        printf("Hello from node %d\n", id);

        soclib_io_set(
                base(ICU),
                ICU_MASK_SET,
                3);

        soclib_io_set(
                base(UART),
                UART_BR,
                500);

        soclib_io_set(
                base(UART),
                UART_CTRL,
                0); //rx_en and tx_en and irq_en disabled

        soclib_io_set(
                base(TIMER),
                0*TIMER_SPAN+TIMER_PERIOD,
                period);
        soclib_io_set(
                base(TIMER),
                0*TIMER_SPAN+TIMER_MODE,
                TIMER_RUNNING|TIMER_IRQ_ENABLED);

        enable_hw_irq(0);
        irq_enable();

        while (1)
	  {
	    if (irq_flag==1)
	      {
		irq_flag=0;
		switch (cptms)
		  {
		  case 1:
		    if (id==0)
		      {
			soclib_io_set(
				      base(UART),
				      UART_CTRL,
				      2);
		      }
		    else
		      {
			soclib_io_set(
				      base(UART),
				      UART_CTRL,
				      5);
		      }
		    first=1;
		    break;
		  case 2:
		    if ((id==0)&&(first==1))
		      {
			printf("2 ms node #0 sends data\n\r");
			sensor=40;

			soclib_io_set(
				      base(UART),
				      UART_DATA,
				      sensor);
			first=0;
		      }
		    break;
		  case 3:
		    if (id==1)
		      {
			soclib_io_set(
				      base(UART),
				      UART_CTRL,
				      2);
		      }
		    else
		      {
			soclib_io_set(
				      base(UART),
				      UART_CTRL,
				      5);
		      }
		    first=1;
		    break;
		  case 4:
		    if ((id==1)&&(first==1))
		      {
			printf("4 ms node #1 sends data\n\r");
			sensor=41;

			soclib_io_set(
				      base(UART),
				      UART_DATA,
				      sensor);
			first=0;
		      }
		    break;
		  default:
		    break;
		  }
	      }
	  }

	return 0;
}
