/*
 * SOCLIB_LGPL_HEADER_BEGIN
 *
 * This file is part of SoCLib, GNU LGPLv2.1.
 *
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 *
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * SOCLIB_LGPL_HEADER_END
 *
 * Copyright (c) UPMC, Lip6, SoC
 *         Francois Pecheux <francois.pecheux@lip6.fr>
 *         Antoine LEVEQUE <antoine.leveque@lip6.fr>
 *
 */

#include <iostream>
#include <cstdlib>

#include "systemc.h"
#include "node.h"

#define NB_NODE 2

//small function for binding name
const char * tostring(const char * name, int val){
  std::ostringstream temp;
  temp << name << val;
  return (temp.str()).c_str();
}

int _main(int argc, char *argv[])
{
        ////////////////////////////////////////////////////////////////////
        // Signals                                                        //
        ////////////////////////////////////////////////////////////////////

	sc_clock	s_clk("s_clk", sc_core::sc_time(10, sc_core::SC_NS));
	sc_signal<bool> s_resetn("s_resetn");

	sc_signal<bool> *s_uart_tx_emitted[2];
	sc_signal<bool> *s_uart_rx_received[2];
	sc_signal<bool> *s_uart_tx_en[2];
	sc_signal<bool> *s_uart_rx_en[2];

        ////////////////////////////////////////////////////////////////////
        // Instances                                                      //
        ////////////////////////////////////////////////////////////////////

	node *n[2];

        ////////////////////////////////////////////////////////////////////
        // Netlist                                                        //
        ////////////////////////////////////////////////////////////////////

    s_uart_rx_received[0] = new sc_core::sc_signal<bool>(tostring("s_uart_rx_received",0));
	s_uart_tx_emitted[0]  = new sc_core::sc_signal<bool>(tostring("s_uart_tx_emitted",0));
	s_uart_tx_en[0]       = new sc_core::sc_signal<bool>(tostring("s_uart_tx_en",0));
	s_uart_rx_en[0]       = new sc_core::sc_signal<bool>(tostring("s_uart_rx_en",0));

	n[0] = new node (tostring("n",0),0,"soft/bin.soft");
	n[0]->p_clk(s_clk);
	n[0]->p_resetn(s_resetn);
	n[0]->p_tx(*s_uart_tx_emitted[0]);
	n[0]->p_rx(*s_uart_rx_received[0]);
	n[0]->p_tx_en(*s_uart_tx_en[0]);
	n[0]->p_rx_en(*s_uart_rx_en[0]);

    s_uart_rx_received[1] = new sc_core::sc_signal<bool>(tostring("s_uart_rx_received",1));
	s_uart_tx_emitted[1]  = new sc_core::sc_signal<bool>(tostring("s_uart_tx_emitted",1));
	s_uart_tx_en[1]       = new sc_core::sc_signal<bool>(tostring("s_uart_tx_en",1));
	s_uart_rx_en[1]       = new sc_core::sc_signal<bool>(tostring("s_uart_rx_en",1));

	n[1] = new node (tostring("n",1),1,"soft/bin.soft");
	n[1]->p_clk(s_clk);
	n[1]->p_resetn(s_resetn);
	n[1]->p_tx(*s_uart_rx_received[0]);
	n[1]->p_rx(*s_uart_tx_emitted[0]);
	n[1]->p_tx_en(*s_uart_tx_en[1]);
	n[1]->p_rx_en(*s_uart_rx_en[1]);

         ////////////////////////////////////////////////////////////////////
        // Simulation                                                     //
        ////////////////////////////////////////////////////////////////////

	sc_start(sc_core::sc_time(0, sc_core::SC_NS));
	s_resetn = false;
	sc_start(sc_core::sc_time(1, sc_core::SC_NS));
	s_resetn = true;

	sc_core::sc_start();
	return EXIT_SUCCESS;
}

int sc_main (int argc, char *argv[])
{
	try {
		return _main(argc, argv);
	} catch (std::exception &e) {
		std::cout << e.what() << std::endl;
	} catch (...) {
		std::cout << "Unknown exception occured" << std::endl;
		throw;
	}
	return 1;
}
