#!/usr/bin/env python

from stratus import *

# definition du bloc mux
class mux ( Model ) :

  # declaration des connecteurs
  def Interface ( self ) :
    # recuperation du parametre
    self.n = self._param['nbit']

    # connecteurs
    self.i0  = SignalIn  ( "i0", self.n )
    self.i1  = SignalIn  ( "i1", self.n )
    self.cmd = SignalIn  ( "cmd", 1 )
    self.s   = SignalOut ( "s", self.n )
    self.vdd = VddIn ( "vdd" )
    self.vss = VssIn ( "vss" )

  # instanciation des cellules
  def Netlist ( self ) :
    for i in range ( self.n ) :
      Inst ( "mx2_x2"
           , map = { 'i0'  : self.i0[i]
                   , 'i1'  : self.i1[i]
                   , 'cmd' : self.cmd
                   , 'q'   : self.s[i]
                   , 'vdd' : self.vdd
                   , 'vss' : self.vss
                   }
           )

  def Pattern ( self ) :
    pat = PatWrite(self._name+'.pat',self)
   
    # declaration de l interface 
    pat.declar(self.i0,'X')
    pat.declar(self.i1,'X')
    pat.declar(self.cmd,'B')
    pat.declar(self.s,'X')
    
    pat.declar(self.vdd, 'B')
    pat.declar(self.vss, 'B')

    pat.pattern_begin()
    
    # affectation des valeurs
    pat.affect_int(self.vdd,1)
    pat.affect_int(self.vss,0)
    
    for i0 in range ( self.n ) :
      for i1 in range ( self.n ) :
        for c in range ( 2 ) :
          pat.affect_int ( self.i0,  i0 )
          pat.affect_int ( self.i1,  i1 )
          pat.affect_int ( self.cmd,  c )
          if c == 1 : pat.affect_int ( self.s, i1 )
          else      : pat.affect_int ( self.s, i0 )
          # ajout du pattern
          pat.addpat()

    del pat
