#!/usr/bin/env python

from stratus import *


class amd2901_dpt ( Model ) :

  def Interface ( self ) :

    # Command for selecting operands R and S.
    self.ops_mx     = SignalIn    ( "ops_mx",     3 )
    self.opr_mx     = SignalIn    ( "opr_mx",     2 )
                                                 
    # ALU commands and auxiliary terminals.      
    self.alu_k      = SignalIn    ( "alu_k",      5 )
    self.alu_cin    = SignalIn    ( "alu_cin",    1 ) 
    self.alu_cout   = SignalOut   ( "alu_cout",   1 ) 
    self.alu_over   = SignalInOut ( "alu_over",   1 )
    
    # RAM, ACCU shifter commands and auxiliary terminals.
    self.ram_sh     = SignalIn    ( "ram_sh",     2 ) 
    self.acc_sh     = SignalIn    ( "acc_sh",     2 ) 
    
    # RAM shifter inputs
    self.ram_i_up   = SignalIn    ( "ram_i_up",   1 )
    self.ram_i_down = SignalIn    ( "ram_i_down", 1 )
    
    # ACCU shifter inputs.
    self.acc_i_up   = SignalIn    ( "acc_i_up",   1 ) 
    self.acc_i_down = SignalIn    ( "acc_i_down", 1 ) 
    
    # ACCU shifter outputs ("acc_scout" is "acc_q_up").
    self.acc_q_down = SignalOut   ( "acc_q_down", 1 )
    self.acc_q_up   = SignalOut   ( "acc_q_up",   1 )
    
    # Output multiplexer commnand (for X bus).
    self.out_mx     = SignalIn    ( "out_mx",     1 )
    
    # ACCU controls terminals.
    self.acc_ck     = SignalIn    ( "acc_ck",     1 )
    self.acc_wen    = SignalIn    ( "acc_wen",    1 )
    
    # Register file controls terminals.
    self.ram_ck     = SignalIn    ( "ram_ck",    16 )   # Register clocks (ck) 
    self.b_w        = SignalIn    ( "b_w",       16 )   # Write enable 
    self.a          = SignalIn    ( "a",         16 )   # Register A address. 
    self.b          = SignalIn    ( "b",         16 )   # Register B address. 
    
    # Data buses terminals.
    self.opr_d      = SignalIn    ( "opr_d",      4 )
    self.alu_f      = SignalInOut ( "alu_f",      4 )
    self.alu_np     = SignalOut   ( "alu_np",     4 )
    self.alu_ng     = SignalOut   ( "alu_ng",     4 )
    self.out_x      = SignalOut   ( "out_x",      4 )
     
    # Power supply connectors. 
    self.vdd = VddIn ( "vdd" )
    self.vss = VssIn ( "vss" )


  def Netlist ( self ) :

    Generate ( "DpgenSff",                    "sff_4bits", param = {'nbit' : 4} )
    Generate ( "DpgenNbuse",                "nbuse_4bits", param = {'nbit' : 4} )
    Generate ( "DpgenInv",             "inv_drive8_4bits", param = {'nbit' : 4, 'drive' : 8} )

    # List of Signals  
    ram_d       = Signal ( "ram_d",      4 )
    ram_nra     = Signal ( "ram_nra",    4 )
    ram_nrb     = Signal ( "ram_nrb",    4 )
    ram_ra      = Signal ( "ram_ra",     4 )
    ram_rb      = Signal ( "ram_rb",     4 )
                                         
    # Array of Signals
    ram_q = []
    for i in range ( 16 ) : ram_q += [Signal ( "ram_q%ld" % i, 4 )]
      
    # Register file description.
    self.ram_reg  = {}
    self.ram_ntsa = {}
    self.ram_ntsb = {}
    
    for i in range ( 16 ) :
      # Register part.
      self.ram_reg[i] = Inst ( "sff_4bits", "ram_reg%ld" % i
                             , map   = { 'wen'  : self.b_w[i]
                                       , 'ck'   : self.ram_ck[i]
                                       , 'i0'   : ram_d
                                       , 'q'    : ram_q[i]
                                       , 'vdd'  : self.vdd
                                       , 'vss'  : self.vss
                                       }
                             )
      
      # Tristate for A output. 
      self.ram_ntsa[i] = Inst ( "nbuse_4bits", "ram_ntsa%ld" % i
                              , map   = { 'cmd'  : self.a[i]
                                        , 'i0'   : ram_q[i]
                                        , 'nq'   : ram_nra
                                        , 'vdd'  : self.vdd
                                        , 'vss'  : self.vss
                                        }
                              )

      
      # Tristate for B output. 
      self.ram_ntsb[i] = Inst ( "nbuse_4bits", "ram_ntsb%ld" % i
                              , map   = { 'cmd'  : self.b[i]
                                        , 'i0'   : ram_q[i]
                                        , 'nq'   : ram_nrb
                                        , 'vdd'  : self.vdd
                                        , 'vss'  : self.vss
                                        }
                              )

    
    # Output drivers for A & B output. 
    self.inv_ra = Inst ( "inv_drive8_4bits", "inv_ra"
                       , map   = { 'i0'    : ram_nra
                                 , 'nq'    : ram_ra
                                 , 'vdd'   : self.vdd
                                 , 'vss'   : self.vss
                                 }
                       )

    self.inv_rb = Inst ( "inv_drive8_4bits", "inv_rb"
                       , map   = { 'i0'    : ram_nrb
                                 , 'nq'    : ram_rb
                                 , 'vdd'   : self.vdd
                                 , 'vss'   : self.vss
                                 }
                       )
     
    #  --------------------------------------------------------------
    #  RAM shifter.
    ##### A COMPLETER #####
    
    # *********************** Operand S ************************ 
    ##### A COMPLETER #####
     
    # *********************** Operand R ************************ 
    ##### A COMPLETER #####
    
    # *********************** ALU Description ****************** 
    ##### A COMPLETER #####
     
    # Compute of "generate".
    ##### A COMPLETER #####

    # Compute of "propagate". 
    ##### A COMPLETER #####
    
    # Compute of carry. 
    ##### A COMPLETER #####
    
    # Logical and arithmetical operators. 
    ##### A COMPLETER #####
     
    # Output. 
    ##### A COMPLETER #####
     
    # ******************** ACCU Description ******************** 
    ##### A COMPLETER #####
     
    # ******************* Output Multiplexer ******************* 
    ##### A COMPLETER #####

