#!/usr/bin/env python


import sys
import stratus
import traceback


def buildBlock ( name ):
    try:
      module = __import__( name, globals(), locals(), name )
      if not module.__dict__.has_key(name):
          print '[ERROR] Stratus module <%s> do not contains a design of the same name.' % name
          sys.exit(1)

      print '     - Generating block <%s>' % name
      block = module.__dict__[name](name)
      block.Interface()
      block.Netlist  ()
      block.Layout   ()
      block.View     (1, 'Block %s'% name)
      block.Save     (stratus.LOGICAL|stratus.PHYSICAL)
    except ImportError, e:
      module = str(e).split()[-1]
    
      print '[ERROR] The <%s> Stratus design cannot be loaded.' % module
      print '        Please check your design hierarchy.'
      sys.exit(1)
    except Exception, e:
      print '[ERROR] A strange exception occurred while loading the Stratus'
      print '        design <%s>. Please check that module for error:\n' % name
      traceback.print_tb(sys.exc_info()[2])
      print '        %s' % e
      sys.exit(2)
    return


def ScriptMain ( cell=None ):
  if globals().has_key ( "__editor" ):
    stratus.setEditor ( __editor )

  print '  o  User-defined MIPS building blocks.'
  blockNames = ( 'alutestn', 'ir16', 'ir18', 'x_const', 'y_const', 'statcaus', 'shamt' )
  for name in blockNames:
    buildBlock( name )

  print '  o  MIPS Datapath.'
  buildBlock( 'mips_dpt' )

 #print '  o  MIPS Core.'
 #buildBlock( 'mips_core' )

 #print '  o  MIPS Chip.'
 #buildBlock( 'mips_chip' )
  return


if __name__ == '__main__':
  ScriptMain ()
  sys.exit(0)
