#!/usr/bin/env python

from stratus import *


class alutestn ( Model ):

  def Interface ( self ):
    self.alu_mx5i0  = SignalIn ( "alu_mx5i0" ,  1 )
    self.alu_test_n = SignalIn ( "alu_test_n",  1 )
    self.out_mux5   = SignalIn ( "out_mux5"  , 32 )
    self.alu_out    = SignalOut( "alu_out"   , 32 )
    self.vdd        = VddIn    ( "vdd" )
    self.vss        = VssIn    ( "vss" )
    return


  def Netlist ( self ):
    Generate( "DpgenAnd2", "a2_b31", param = {'nbit':31, 'physical' : True} )

    self.mux5_0n = Signal( "mux5_0n", 1 )

    self.instances  = []
    self.instances += [ Inst( 'inv_x1', 'inv_0'
                            , map = { 'i'  :self.out_mux5[0]
                                    , 'nq' :self.mux5_0n
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # Bit 0.
    self.instances += [ Inst( 'nmx2_x1', 'nmx2_1'
                            , map = { 'cmd':self.alu_mx5i0
                                    , 'i0' :self.alu_test_n
                                    , 'i1' :self.mux5_0n
                                    , 'nq' :self.alu_out[0]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # Bits 1-31.
    self.instances += [ Inst( 'a2_b31', 'a2_2'
                            , map = { 'i0' :self.out_mux5[1:31]
                                    , 'i1' :Cat( self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0
                                               , self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0
                                               , self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0
                                               , self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0
                                               , self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0
                                               , self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0, self.alu_mx5i0
                                               , self.alu_mx5i0 )
                                    , 'q'  :self.alu_out[1:31]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    return


  def Layout ( self ):
    islice = 0
    for iinstance in range(len(self.instances)):
      orientation = NOSYM
      if islice % 2: orientation = SYM_Y

      Place( self.instances[iinstance], orientation, XY(0,50*islice) )

      if self.instances[iinstance]._name == 'a2_2': islice += 31
      else:
        islice += 1
    return
