#!/usr/bin/env python

from stratus import *


class ir18 ( Model ):

  def Interface ( self ):
    self.opy_mx2  = SignalIn ( "opy_mx2" ,  1 )
    self.ir       = SignalIn ( "ir"      , 26 )
    self.opy_ir18 = SignalOut( "opy_ir18", 32 )
    self.vdd      = VddIn    ( "vdd" )
    self.vss      = VssIn    ( "vss" )
    return

  def Netlist ( self ):
    Generate( "DpgenNmux2", "nmux2_b10", param = {'nbit':10, 'physical' : True} )

    self.ir15      = Signal( "ir15"     , 1 )
    self.opy_mx2_n = Signal( "opy_mx2_n", 1 )

    self.instances = []
   # bits 0-1.
    for i in range(0,2):
        self.instances += [ Inst( 'one_x0', 'one_%d'%(i)
                                , map = { 'q'  :self.opy_ir18[i]
                                        , 'vdd':self.vdd
                                        , 'vss':self.vss
                                        }
                                ) ]
   # bits 2-16.
    for i in range(2,17):
      self.instances += [ Inst( 'inv_x1', 'inv_%d'%(i)
                              , map = { 'i'  :self.ir[i-2]
                                      , 'nq' :self.opy_ir18[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]

   # bit 17 (uses slices 17, 18 & 19).
    self.instances += [ Inst( 'inv_x1', 'inv_17'
                            , map = { 'i'  :self.ir[15]
                                    , 'nq' :self.ir15
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'buf_x2', 'buf_18'
                            , map = { 'i'  :self.ir15
                                    , 'q'  :self.opy_ir18[17]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'inv_x1', 'inv_19'
                            , map = { 'i'  :self.opy_mx2
                                    , 'nq' :self.opy_mx2_n
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bits 18-27.
    self.instances += [ Inst( 'nmux2_b10', 'nmux2_20'
                            , map = { 'cmd':self.opy_mx2
                                    , 'i0' :Cat(self.ir[15],self.ir[15],self.ir[15],self.ir[15],self.ir[15]
                                               ,self.ir[15],self.ir[15],self.ir[15],self.ir[15],self.ir[15])
                                    , 'i1' :self.ir[25:16]
                                    , 'nq' :self.opy_ir18[27:18]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bits 28-31.
    for i in range(28,32):
      self.instances += [ Inst( 'o2_x2', 'o2_%d'%(i+2)
                              , map = { 'i0' :self.opy_mx2_n
                                      , 'i1' :self.ir15
                                      , 'q'  :self.opy_ir18[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
    return


  def Layout ( self ):
    islice = 0
    for iinstance in range(len(self.instances)):
      orientation = NOSYM
      if islice % 2: orientation = SYM_Y

      Place( self.instances[iinstance], orientation, XY(0,50*islice) )

      if self.instances[iinstance]._name == 'nmux2_20': islice += 12
      else:
        islice += 1
    return
