#!/usr/bin/env python

from stratus import *


class shamt ( Model ):

  def Interface ( self ):
    self.ir    = SignalIn ( "ir"   ,  5 )
    self.shamt = SignalOut( "shamt", 32 )
    self.vdd   = VddIn    ( "vdd" )
    self.vss   = VssIn    ( "vss" )
    return


  def Netlist ( self ):
    self.ir4_1p     = Signal( "ir4_1p"    , 1 )
    self.ir4_2p     = Signal( "ir4_2p"    , 1 )
    self.ir4_3p     = Signal( "ir4_3p"    , 1 )
    self.ir4_4p     = Signal( "ir4_4p"    , 1 )
    self.ir4_5p     = Signal( "ir4_5p"    , 1 )

    self.instances = []
   # Bits 0-3.
    for i in range(0,4):
      self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i)
                              , map = { 'i'  :self.ir[i]
                                      , 'q'  :self.shamt[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
   # bit 4.
    self.instances += [ Inst( 'buf_x2', 'buf_4'
                            , map = { 'i'  :self.ir[4]
                                    , 'q'  :self.ir4_1p
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'buf_x2', 'buf_5'
                            , map = { 'i'  :self.ir4_1p
                                    , 'q'  :self.shamt[4]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # Bits 5-12.
    self.instances += [ Inst( 'buf_x2', 'buf_6'
                            , map = { 'i'  :self.ir[4]
                                    , 'q'  :self.ir4_2p
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    for i in range(5,13):
      self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i+2)
                              , map = { 'i'  :self.ir4_2p
                                      , 'q'  :self.shamt[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
   # Bits 13-19.
    self.instances += [ Inst( 'buf_x2', 'buf_15'
                            , map = { 'i'  :self.ir[4]
                                    , 'q'  :self.ir4_3p
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    for i in range(13,20):
      self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i+3)
                              , map = { 'i'  :self.ir4_3p
                                      , 'q'  :self.shamt[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
   # Bits 20-26.
    self.instances += [ Inst( 'buf_x2', 'buf_23'
                            , map = { 'i'  :self.ir[4]
                                    , 'q'  :self.ir4_4p
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    for i in range(20,27):
      self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i+4)
                              , map = { 'i'  :self.ir4_4p
                                      , 'q'  :self.shamt[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
   # Bits 27-31.
    self.instances += [ Inst( 'buf_x2', 'buf_31'
                            , map = { 'i'  :self.ir[4]
                                    , 'q'  :self.ir4_5p
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    for i in range(27,32):
      self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i+5)
                              , map = { 'i'  :self.ir4_5p
                                      , 'q'  :self.shamt[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
    return


  def Layout ( self ):
    for islice in range(len(self.instances)):
      orientation = NOSYM
      if islice % 2: orientation = SYM_Y

      Place( self.instances[islice], orientation, XY(0,50*islice) )
    return
