#!/usr/bin/env python

from stratus import *


class ir16 ( Model ):

  def Interface ( self ):
    self.opy_mx3  = SignalIn ( "opy_mx3" ,  1 )
    self.ir       = SignalIn ( "ir"      , 16 )
    self.opy_ir16 = SignalOut( "opy_ir16", 32 )
    self.vdd      = VddIn    ( "vdd" )
    self.vss      = VssIn    ( "vss" )
    return

  def Netlist ( self ):
    self.opy_mx3_n_1 = Signal( "opy_mx3_n_1", 1 )
    self.opy_mx3_n_2 = Signal( "opy_mx3_n_2", 1 )
    self.bit15       = Signal( "bit15"      , 1 )
    self.bit15p      = Signal( "bit15p"     , 1 )

    self.instances  = []
    self.instances += [ Inst( 'inv_x1', 'inv_0'
                            , map = { 'i'  :self.opy_mx3
                                    , 'nq' :self.opy_mx3_n_1
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bits 0-7.
    for i in range(0,8):
      self.instances += [ Inst( 'na2_x1', 'na2_%d'%(i+1)
                              , map = { 'i0' :self.opy_mx3_n_1
                                      , 'i1' :self.ir[i]
                                      , 'nq' :self.opy_ir16[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]

    self.instances += [ Inst( 'inv_x1', 'inv_9'
                            , map = { 'i'  :self.opy_mx3
                                    , 'nq' :self.opy_mx3_n_2
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bits 8-14.
    for i in range(8,15):
      self.instances += [ Inst( 'na2_x1', 'na2_%d'%(i+2)
                              , map = { 'i0' :self.opy_mx3_n_2
                                      , 'i1' :self.ir[i]
                                      , 'nq' :self.opy_ir16[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
   # bit 15.
    self.instances += [ Inst( 'na2_x1', 'na2_17'
                            , map = { 'i0' :self.opy_mx3_n_2
                                    , 'i1' :self.ir[15]
                                    , 'nq' :self.bit15
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'buf_x2', 'buf_18'
                            , map = { 'i'  :self.bit15
                                    , 'q'  :self.opy_ir16[15]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bits 16-21.
    for i in range(16,22):
      self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i+3)
                              , map = { 'i'  :self.bit15
                                      , 'q'  :self.opy_ir16[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
   # bits 22-31.
    self.instances += [ Inst( 'buf_x2', 'buf_25'
                            , map = { 'i'  :self.bit15
                                    , 'q'  :self.bit15p
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    for i in range(22,32):
      self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i+4)
                              , map = { 'i'  :self.bit15p
                                      , 'q'  :self.opy_ir16[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
    return


  def Layout ( self ):
    for islice in range(len(self.instances)):
      orientation = NOSYM
      if islice % 2: orientation = SYM_Y

      Place( self.instances[islice], orientation, XY(0,50*islice) )
    return
