#!/usr/bin/env python

from stratus import *


class y_const ( Model ):

  def Interface ( self ):
    self.opy_mx4   = SignalIn ( "opy_mx4"  ,  1 )
    self.opy_ts4   = SignalIn ( "opy_ts4"  ,  1 )
    self.opy_ts5   = SignalIn ( "opy_ts5"  ,  1 )
    self.opy_ts6   = SignalIn ( "opy_ts6"  ,  1 )
    self.const_out = SignalOut( "const_out", 32 )
    self.vdd       = VddIn    ( "vdd" )
    self.vss       = VssIn    ( "vss" )
    return


  def Netlist ( self ):
    self.mx4n     = Signal( "mx4n"    , 1 )
    self.mx4_ts4  = Signal( "mx4_ts4" , 1 )
    self.mx4_ts6  = Signal( "mx4_ts6" , 1 )
    self.mx4n_ts4 = Signal( "mx4n_ts4", 1 )

    self.instances  = []

   # Bit 0.
    self.instances += [ Inst( 'zero_x0', 'zero_0'
                            , map = { 'nq' :self.const_out[0]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # Bit 1.
    self.instances += [ Inst( 'zero_x0', 'zero_1'
                            , map = { 'nq' :self.const_out[1]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # Bit 2.
    self.instances += [ Inst( 'inv_x1', 'inv_2'
                            , map = { 'i'  :self.opy_mx4
                                    , 'nq' :self.mx4n
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'a2_x2', 'a2_3'
                            , map = { 'i0' :self.mx4n
                                    , 'i1' :self.opy_ts4
                                    , 'q'  :self.mx4n_ts4
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'o2_x2', 'o2_4'
                            , map = { 'i0' :self.mx4n_ts4
                                    , 'i1' :self.mx4n_ts4
                                    , 'q'  :self.const_out[2]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bit 3.
    self.instances += [ Inst( 'buf_x2', 'buf_5'
                            , map = { 'i'  :self.opy_ts6
                                    , 'q'  :self.const_out[3]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bit 4.
    self.instances += [ Inst( 'a2_x2', 'a2_6'
                            , map = { 'i0' :self.opy_mx4
                                    , 'i1' :self.opy_ts4
                                    , 'q'  :self.mx4_ts4
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'a2_x2', 'a2_7'
                            , map = { 'i0' :self.opy_mx4
                                    , 'i1' :self.opy_ts6
                                    , 'q'  :self.mx4_ts6
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'o2_x2', 'o2_8'
                            , map = { 'i0' :self.mx4_ts4
                                    , 'i1' :self.mx4_ts6
                                    , 'q'  :self.const_out[4]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bits 5-21.
    for i in range(5,22):
        self.instances += [ Inst( 'zero_x0', 'zero_%d'%(i+4)
                                , map = { 'nq' :self.const_out[i]
                                        , 'vdd':self.vdd
                                        , 'vss':self.vss
                                        }
                                ) ]
   # bits 22-29.
    for i in range(22,30):
        self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i+4)
                                , map = { 'i'  :self.opy_ts5
                                        , 'q'  :self.const_out[i]
                                        , 'vdd':self.vdd
                                        , 'vss':self.vss
                                        }
                                ) ]
   # bit 30.
    self.instances += [ Inst( 'zero_x0', 'zero_34'
                            , map = { 'nq' :self.const_out[30]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bit 31.
    self.instances += [ Inst( 'buf_x2', 'buf_35'
                            , map = { 'i'  :self.opy_ts5
                                    , 'q'  :self.const_out[31]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    return


  def Layout ( self ):
    for islice in range(len(self.instances)):
      orientation = NOSYM
      if islice % 2: orientation = SYM_Y

      Place( self.instances[islice], orientation, XY(0,50*islice) )
    return
