#!/usr/bin/env python

from stratus import *


class mips_dpt ( Model ):

  def Interface ( self ):

    self.test         = SignalIn   ( "test"     , 1 )
    self.dpt_scin     = SignalIn   ( "dpt_scin" , 1 )
    self.dpt_scout    = SignalOut  ( "dpt_scout", 1 )
    self.ck           = SignalIn   ( "ck"       , 1 )
                      
    self.pc_wen       = SignalIn   ( "pc_wen"   , 1 )
    self.ad_wen       = SignalIn   ( "ad_wen"   , 1 )
    self.epc_wen      = SignalIn   ( "epc_wen"  , 1 )
    self.bar_wen      = SignalIn   ( "bar_wen"  , 1 )
    self.ir_wen       = SignalIn   ( "ir_wen"   , 1 )
    self.dt_wen       = SignalIn   ( "dt_wen"   , 1 )
    self.hi_wen       = SignalIn   ( "hi_wen"   , 1 )
    self.lo_wen       = SignalIn   ( "lo_wen"   , 1 )
    self.rf_wen       = SignalIn   ( "rf_wen"   , 1 )
                      
    self.rf_aw        = SignalIn   ( "rf_aw"    , 5 )
    self.rf_ar        = SignalIn   ( "rf_ar"    , 5 )
                      
    self.opx_ts7      = SignalIn   ( "opx_ts7"  , 1 )
    self.opx_ts6      = SignalIn   ( "opx_ts6"  , 1 )
    self.opx_ts5      = SignalIn   ( "opx_ts5"  , 1 )
    self.opx_ts4      = SignalIn   ( "opx_ts4"  , 1 )
    self.opx_ts3      = SignalIn   ( "opx_ts3"  , 1 )
    self.opx_ts2      = SignalIn   ( "opx_ts2"  , 1 )
    self.opx_ts1      = SignalIn   ( "opx_ts1"  , 1 )
    self.opx_ts0      = SignalIn   ( "opx_ts0"  , 1 )
                      
    self.opx_mx7      = SignalIn   ( "opx_mx7"  , 1 )
    self.opx_mx6      = SignalIn   ( "opx_mx6"  , 1 )
    self.opx_mx5      = SignalIn   ( "opx_mx5"  , 1 )
    self.opx_mx4      = SignalIn   ( "opx_mx4"  , 1 )
    self.opx_mx3      = SignalIn   ( "opx_mx3"  , 1 )
    self.opx_mx2      = SignalIn   ( "opx_mx2"  , 1 )
    self.opx_mx1      = SignalIn   ( "opx_mx1"  , 1 )
                          
    self.opx_sign     = SignalOut  ( "opx_sign" , 1 )

    self.crsr_dpt_out = SignalOut  ( "crsr_dpt_out", 16 )
    self.crsr_sts_in  = SignalIn   ( "crsr_sts_in" , 16 )
 
    self.opy_ts6      = SignalIn   ( "opy_ts6", 1 )
    self.opy_ts5      = SignalIn   ( "opy_ts5", 1 )
    self.opy_ts4      = SignalIn   ( "opy_ts4", 1 )
    self.opy_ts3      = SignalIn   ( "opy_ts3", 1 )
    self.opy_ts2      = SignalIn   ( "opy_ts2", 1 )
    self.opy_ts1      = SignalIn   ( "opy_ts1", 1 )
                      
    self.opy_mx6      = SignalIn   ( "opy_mx6", 1 )
    self.opy_mx5      = SignalIn   ( "opy_mx5", 1 )
    self.opy_mx4      = SignalIn   ( "opy_mx4", 1 )
    self.opy_mx3      = SignalIn   ( "opy_mx3", 1 )
    self.opy_mx2      = SignalIn   ( "opy_mx2", 1 )
    self.opy_mx1      = SignalIn   ( "opy_mx1", 1 )

    self.opy_codop    = SignalOut  ( "opy_codop", 19 )
    self.opy_rs       = SignalOut  ( "opy_rs"   ,  5 )
    self.opy_rdrt     = SignalOut  ( "opy_rdrt" ,  5 )
    self.opy_rd       = SignalOut  ( "opy_rd"   ,  5 )
    self.opy_sign     = SignalOut  ( "opy_sign" ,  1 )
  
    self.data_in_dpt  = SignalIn   ( "data_in_dpt", 32 )
  
    self.alu_mx5i0    = SignalIn   ( "alu_mx5i0", 1 )
    self.alu_mx4i0    = SignalIn   ( "alu_mx4i0", 1 )
    self.alu_mx3i0    = SignalIn   ( "alu_mx3i0", 1 )
    self.alu_mx2i0    = SignalIn   ( "alu_mx2i0", 1 )
    self.alu_mx2i1    = SignalIn   ( "alu_mx2i1", 1 )
    self.alu_mx1i2    = SignalIn   ( "alu_mx1i2", 1 )
    self.alu_mx1i1    = SignalIn   ( "alu_mx1i1", 1 )
    self.alu_mx1i0    = SignalIn   ( "alu_mx1i0", 1 )
    self.alu_mx0i0    = SignalIn   ( "alu_mx0i0", 1 )
  
    self.alu_byte     = SignalIn   ( "alu_byte"  ,  1 )
    self.alu_half     = SignalIn   ( "alu_half"  ,  1 )
    self.alu_test_n   = SignalIn   ( "alu_test_n",  1 )
    self.alu_c31      = SignalOut  ( "alu_c31"   ,  1 )
    self.alu_c30      = SignalOut  ( "alu_c30"   ,  1 )
    self.alu_nul      = SignalOut  ( "alu_nul"   ,  1 )
    self.alu_sign     = SignalOut  ( "alu_sign"  ,  1 )
  
    self.data_out_dpt = SignalOut  ( "data_out_dpt", 32 )
    self.out_mx0i0    = SignalIn   ( "out_mx0i0"   , 1  )
    self.out_adr      = SignalOut  ( "out_adr"     , 32 )
    self.alu_n_31     = SignalInOut( "alu_n_31"    , 1  )
    self.alu_n_1      = SignalInOut( "alu_n_1"     , 1  )
    self.alu_n_0      = SignalInOut( "alu_n_0"     , 1  )
   
    self.adr_n_1      = SignalInOut( "adr_n_1", 1 )
    self.adr_n_0      = SignalInOut( "adr_n_0", 1 )
     
   # Power supply connectors. 
    self.vdd = VddIn ( "vdd" )
    self.vss = VssIn ( "vss" )

    return


  def Netlist ( self ) :

    Generate( "DpgenRf1dr0",   "rf1dr0_b32", param = {'nbit':32, 'nword':32, 'physical' : True} )
    Generate( "DpgenSfft",       "sfft_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenBuff",       "buff_b1" , param = {'nbit':1 ,             'physical' : True} )
    Generate( "DpgenNbuse",     "nbuse_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenBuse",       "buse_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenInv",      "inv_d1_b32", param = {'nbit':32, 'drive':1,  'physical' : True} )
    Generate( "DpgenNmux2",     "nmux2_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenShifter", "shifter_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenXor2",       "xor2_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenNand2",     "nand2_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenNor2",       "nor2_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenNul",         "nul_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenMux2",       "mux2_b32", param = {'nbit':32, 'drive':2,  'physical' : True} )
    Generate( "DpgenInv",         "inv_b21", param = {'nbit':21, 'drive':1,  'physical' : True} )
    Generate( "DpgenAdsb2f",   "adsb2f_b32", param = {'nbit':32,             'physical' : True} )
    Generate( "DpgenInv",         "inv_b1" , param = {'nbit':1 , 'drive':1,  'physical' : True} )

   # Signals for Registers:
    self.one   = Signal( 'one'  ,  1 )
    self.pc_s  = Signal( 'pc_s' , 32 )
    self.ad_s  = Signal( 'ad_s' , 32 )
    self.lo_s  = Signal( 'lo_s' , 32 )
    self.hi_s  = Signal( 'hi_s' , 32 )
    self.epc_s = Signal( 'epc_s', 32 )
    self.bar_s = Signal( 'bar_s', 32 )
    self.dt_s  = Signal( 'dt_s' , 32 )
    self.rf_s  = Signal( 'rf_s' , 32 )

    self.dt_s[31].Alias(self.dpt_scout)

   # Signals for Operand X:
   #   opx_out, const_xout, opx_its1, opx_its2, opx_its3, opx_its4, opx_its6.
    self.opx_out = Signal( "opx_out", 32 )
    self.opx_out[31].Alias(self.opx_sign)
    self.const_xout = Signal( 'const_xout', 32 )
    self.opx_its1   = Signal( 'opx_its1'  , 32 )
    self.opx_its2   = Signal( 'opx_its2'  , 32 )
    self.opx_its3   = Signal( 'opx_its3'  , 32 )
    self.opx_its4   = Signal( 'opx_its4'  , 32 )
    self.opx_its6   = Signal( 'opx_its6'  , 32 )

   # Signals for operand Y:
   #   opy_out, opy_its1, opy_its2, opy_its3, opy_its5, const_out
    self.opy_out = Signal( "opy_out" , 32 )
    self.opy_out[31].Alias(self.opy_sign)
    self.const_out = Signal( 'const_out', 32 )
    self.opy_shamt = Signal( 'opy_shamt', 32 )
    self.opy_its1  = Signal( 'opy_its1' , 32 )
    self.opy_its2  = Signal( 'opy_its2' , 32 )
    self.opy_its3  = Signal( 'opy_its3' , 32 )
    self.opy_its5  = Signal( 'opy_its5' , 32 )

    self.ir_ns = Signal( "ir_ns", 32 )
    self.ir_s  = Signal( "ir_s" , 32 )
    for i in range(26,32):
        self.ir_s[i].Alias(self.opy_codop[i-13])
    self.ir_s[25].Alias(self.opy_codop[12])
    self.ir_s[23].Alias(self.opy_codop[11])
    self.ir_s[13].Alias(self.opy_codop[10])
    self.ir_s[12].Alias(self.opy_codop[ 9])
    self.ir_s[11].Alias(self.opy_codop[ 8])
    self.ir_s[16].Alias(self.opy_codop[ 7])
    self.ir_s[20].Alias(self.opy_codop[ 6])
    for i in range(0,6):
        self.ir_s[i].Alias(self.opy_codop[i])
  
    self.rstd_adr_alu = Signal( "rstd_adr_alu", 32 )
    for i in range(15,20): self.rstd_adr_alu[i].Alias(self.opy_rs  [i-15])
    for i in range(10,15): self.rstd_adr_alu[i].Alias(self.opy_rdrt[i-10])
    for i in range( 5,10): self.rstd_adr_alu[i].Alias(self.opy_rd  [i- 5])

    self.rstd_adr_alu[4].Alias(self.adr_n_1 )
    self.rstd_adr_alu[3].Alias(self.adr_n_0 )
    self.rstd_adr_alu[2].Alias(self.alu_n_31)
    self.rstd_adr_alu[1].Alias(self.alu_n_1 )
    self.rstd_adr_alu[0].Alias(self.alu_n_0 )

   # Signals for ALU:
   #   alu_sum, alu_shout, alu_xor, alu_nand, alu_nor, alu_nul, alu_out, data_outb_h, data_outh_n
   #   out_mux1, out_mux2, out_mux3, out_mux4, out_mux5
  
    self.alu_sum     = Signal( "alu_sum"    , 32 )
    self.alu_shout   = Signal( "alu_shout"  , 32 )
    self.alu_xor     = Signal( "alu_xor"    , 32 )
    self.alu_nand    = Signal( "alu_nand"   , 32 )
    self.alu_nor     = Signal( "alu_nor"    , 32 )
    self.alu_out     = Signal( "alu_out"    , 32 )
    self.data_outb_n = Signal( "data_outb_n" , 32 )
    self.data_outh_n = Signal( "data_outh_n" , 32 )
    self.out_mux1    = Signal( "out_mux1"   , 32 )
    self.out_mux2    = Signal( "out_mux2"   , 32 )
    self.out_mux3    = Signal( "out_mux3"   , 32 )
    self.out_mux4    = Signal( "out_mux4"   , 32 )
    self.out_mux5    = Signal( "out_mux5"   , 32 )
    self.alu_c31_n   = Signal( "alu_c31_n"  ,  1 )
    self.alu_c30_n   = Signal( "alu_c30_n"  ,  1 )
    self.alu_mx2i0_n = Signal( "alu_mx2i0_n",  1 )

    self.alu_sum[31].Alias(self.alu_sign)
    for i in range(0,16):
        self.alu_out[i].Alias(self.crsr_dpt_out[i])

   # Registers.
    self.i_one = Inst('one_x0', 'one', map={'q':self.one, 'vdd':self.vdd, 'vss':self.vss})

    self.ir_reg_desc = Inst( 'sfft_b32', 'ir_reg_desc'
                           , map = { 'scan':self.test
                                   , 'scin':self.dpt_scin
                                   , 'wen' :self.ir_wen
                                   , 'ck'  :self.ck
                                   , 'i0'  :self.data_in_dpt
                                   , 'q'   :self.ir_s
                                   , 'vdd' :self.vdd
                                   , 'vss' :self.vss
                                   }
                           )

    self.pc_reg_desc = Inst( 'sfft_b32', 'pc_reg_desc'
                           , map = { 'scan':self.test
                                   , 'scin':self.ir_s[31]
                                   , 'wen' :self.pc_wen
                                   , 'ck'  :self.ck
                                   , 'i0'  :self.alu_out
                                   , 'q'   :self.pc_s
                                   , 'vdd' :self.vdd
                                   , 'vss' :self.vss
                                   }
                           )

    self.ad_reg_desc = Inst( 'sfft_b32', 'ad_reg_desc'
                           , map = { 'scan':self.test
                                   , 'scin':self.pc_s[31]
                                   , 'wen' :self.ad_wen
                                   , 'ck'  :self.ck
                                   , 'i0'  :self.alu_out
                                   , 'q'   :self.ad_s
                                   , 'vdd' :self.vdd
                                   , 'vss' :self.vss
                                   }
                           )
    
    self.hi_reg_desc = Inst( 'sfft_b32', 'hi_reg_desc'
                           , map = { 'scan':self.test
                                   , 'scin':self.ad_s[31]
                                   , 'wen' :self.hi_wen
                                   , 'ck'  :self.ck
                                   , 'i0'  :self.alu_out
                                   , 'q'   :self.hi_s
                                   , 'vdd' :self.vdd
                                   , 'vss' :self.vss
                                   }
                           )
    
    self.lo_reg_desc = Inst( 'sfft_b32', 'lo_reg_desc'
                           , map = { 'scan':self.test
                                   , 'scin':self.hi_s[31]
                                   , 'wen' :self.lo_wen
                                   , 'ck'  :self.ck
                                   , 'i0'  :self.alu_out
                                   , 'q'   :self.lo_s
                                   , 'vdd' :self.vdd
                                   , 'vss' :self.vss
                                   }
                           )
  
    self.epc_reg_desc = Inst( 'sfft_b32', 'epc_reg_desc'
                            , map = { 'scan':self.test
                                    , 'scin':self.lo_s[31]
                                    , 'wen' :self.epc_wen
                                    , 'ck'  :self.ck
                                    , 'i0'  :self.alu_out
                                    , 'q'   :self.epc_s
                                    , 'vdd' :self.vdd
                                    , 'vss' :self.vss
                                    }
                            )
  
    self.bar_reg_desc = Inst( 'sfft_b32', 'bar_reg_desc'
                            , map = { 'scan':self.test
                                    , 'scin':self.epc_s[31]
                                    , 'wen' :self.bar_wen
                                    , 'ck'  :self.ck
                                    , 'i0'  :self.alu_out
                                    , 'q'   :self.bar_s
                                    , 'vdd' :self.vdd
                                    , 'vss' :self.vss
                                    }
                            )
  
    self.dt_reg_desc = Inst( 'sfft_b32', 'dt_reg_desc'
                           , map = { 'scan':self.test
                                   , 'scin':self.bar_s[31]
                                   , 'wen' :self.dt_wen
                                   , 'ck'  :self.ck
                                   , 'i0'  :self.data_in_dpt
                                   , 'q'   :self.dt_s
                                   , 'vdd' :self.vdd
                                   , 'vss' :self.vss
                                   }
                           )

    self.rf1dr0 = Inst( 'rf1dr0_b32', 'wm_rf'
                      , map = { 'ck'     :self.ck
                              , 'sel'    :self.one       # Select write bus.
                              , 'wen'    :self.rf_wen
                              , 'ren'    :self.one       # Read enable.
                              , 'adr'    :self.rf_ar
                              , 'adw'    :self.rf_aw
                              , 'datain0':self.alu_out   # When sel=0.
                              , 'datain1':self.alu_out   # When sel=1.
                              , 'dataout':self.rf_s
                              , 'vdd'    :self.vdd
                              , 'vss'    :self.vss
                              }
                      )

   # X Operand.
   # Signals: opx_out, const_xout, opx_its1, opx_its2, opx_its3, opx_its4, opx_its6.

    self.x_ts0 = Inst( 'buse_b32', 'x_ts0'
                     , map = { 'cmd' :self.opx_ts0
                             , 'i0'  :self.rf_s
                             , 'q'   :self.opx_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.mux_opx_its1 = Inst( 'nmux2_b32', 'mux_opx_its1'
                             , map = { 'cmd' :self.opx_mx1
                                     , 'i0'  :self.pc_s
                                     , 'i1'  :self.ad_s
                                     , 'nq'  :self.opx_its1
                                     , 'vdd' :self.vdd
                                     , 'vss' :self.vss
                                     }
                             )
    self.x_ts1 = Inst( 'nbuse_b32', 'x_ts1'
                     , map = { 'cmd' :self.opx_ts1
                             , 'i0'  :self.opx_its1
                             , 'nq'  :self.opx_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.mux_opx_its2 = Inst( 'nmux2_b32', 'mux_opx_its2'
                             , map = { 'cmd' :self.opx_mx2
                                     , 'i0'  :self.hi_s
                                     , 'i1'  :self.lo_s
                                     , 'nq'  :self.opx_its2
                                     , 'vdd' :self.vdd
                                     , 'vss' :self.vss
                                     }
                             )
    self.x_ts2 = Inst( 'nbuse_b32', 'x_ts2'
                     , map = { 'cmd' :self.opx_ts2
                             , 'i0'  :self.opx_its2
                             , 'nq'  :self.opx_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.statcaus = Inst( 'statcaus', 'statcaus'
                     , map = { 'crsr_sts_in':self.crsr_sts_in
                             , 'opx_its3'   :self.opx_its3
                             , 'vdd'        :self.vdd
                             , 'vss'        :self.vss
                             }
                     )
    self.x_ts3 = Inst( 'nbuse_b32', 'x_ts3'
                     , map = { 'cmd' :self.opx_ts3
                             , 'i0'  :self.opx_its3
                             , 'nq'  :self.opx_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.mux_opx_its4 = Inst( 'nmux2_b32', 'mux_opx_its4'
                             , map = { 'cmd' :self.opx_mx4
                                     , 'i0'  :self.bar_s
                                     , 'i1'  :self.epc_s
                                     , 'nq'  :self.opx_its4
                                     , 'vdd' :self.vdd
                                     , 'vss' :self.vss
                                     }
                             )
    self.x_ts4 = Inst( 'nbuse_b32', 'x_ts4'
                     , map = { 'cmd' :self.opx_ts4
                             , 'i0'  :self.opx_its4
                             , 'nq'  :self.opx_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.x_const = Inst( 'x_const', 'x_const'
                          , map = { 'opx_mx4'  :self.opx_mx7
                                  , 'opx_ts5'  :self.opx_ts5
                                  , 'opx_ts6'  :self.opx_ts6
                                  , 'opx_ts7'  :self.opx_ts7
                                  , 'pc'       :self.pc_s[31:28]
                                  , 'const_out':self.const_xout
                                  , 'vdd'      :self.vdd
                                  , 'vss'      :self.vss
                                  }
                          )
    self.x_ts5 = Inst( 'buse_b32', 'x_ts5'
                     , map = { 'cmd' :self.opx_ts5
                             , 'i0'  :self.const_xout
                             , 'q'   :self.opx_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.mux_opx_its6 = Inst( 'nmux2_b32', 'mux_opx_its6'
                             , map = { 'cmd' :self.opx_mx6
                                     , 'i0'  :self.dt_s
                                     , 'i1'  :self.const_xout
                                     , 'nq'  :self.opx_its6
                                     , 'vdd' :self.vdd
                                     , 'vss' :self.vss
                                     }
                             )
    self.x_ts6 = Inst( 'nbuse_b32', 'x_ts6'
                     , map = { 'cmd' :self.opx_ts6
                             , 'i0'  :self.opx_its6
                             , 'nq'  :self.opx_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.x_ts7 = Inst( 'buse_b32', 'x_ts7'
                     , map = { 'cmd' :self.opx_ts7
                             , 'i0'  :self.const_xout
                             , 'q'   :self.opx_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )

   # Y Operand.
   # Signals: opy_out, opy_its1, opy_its2, opy_its3, opy_its5, const_out
    self.mux_opy_its1 = Inst( 'nmux2_b32', 'mux_opy_its1'
                             , map = { 'cmd' :self.opy_mx1
                                     , 'i0'  :self.ad_s
                                     , 'i1'  :self.dt_s
                                     , 'nq'  :self.opy_its1
                                     , 'vdd' :self.vdd
                                     , 'vss' :self.vss
                                     }
                             )
    self.y_ts1 = Inst( 'nbuse_b32', 'y_ts1'
                     , map = { 'cmd' :self.opy_ts1
                             , 'i0'  :self.opy_its1
                             , 'nq'  :self.opy_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.ir18 = Inst( 'ir18', 'opy_ir18'
                     , map = { 'opy_mx2' :self.opy_mx2
                             , 'ir'      :self.ir_s[25:0]
                             , 'opy_ir18':self.opy_its2
                             , 'vdd'     :self.vdd
                             , 'vss'     :self.vss
                             }
                     )
    self.y_ts2 = Inst( 'nbuse_b32', 'y_ts2'
                     , map = { 'cmd' :self.opy_ts2
                             , 'i0'  :self.opy_its2
                             , 'nq'  :self.opy_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.ir16 = Inst( 'ir16', 'opy_ir16'
                     , map = { 'opy_mx3' :self.opy_mx3
                             , 'ir'      :self.ir_s[15:0]
                             , 'opy_ir16':self.opy_its3
                             , 'vdd'     :self.vdd
                             , 'vss'     :self.vss
                             }
                     )
    self.y_ts3 = Inst( 'nbuse_b32', 'y_ts3'
                     , map = { 'cmd' :self.opy_ts3
                             , 'i0'  :self.opy_its3
                             , 'nq'  :self.opy_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.y_const = Inst( 'y_const', 'y_const'
                          , map = { 'opy_mx4'  :self.opy_mx4
                                  , 'opy_ts4'  :self.opy_ts4
                                  , 'opy_ts5'  :self.opy_ts5
                                  , 'opy_ts6'  :self.opy_ts6
                                  , 'const_out':self.const_out
                                  , 'vdd'      :self.vdd
                                  , 'vss'      :self.vss
                                  }
                          )
    self.y_ts4 = Inst( 'buse_b32', 'y_ts4'
                     , map = { 'cmd' :self.opy_ts4
                             , 'i0'  :self.const_out
                             , 'q'   :self.opy_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.shamt = Inst( 'shamt', 'shamt'
                          , map = { 'ir'   :self.ir_s[10:6]
                                  , 'shamt':self.opy_shamt[31:0]
                                  , 'vdd'  :self.vdd
                                  , 'vss'  :self.vss
                                  }
                          )
    self.mux_opy_its5 = Inst( 'nmux2_b32', 'mux_opy_its5'
                             , map = { 'cmd' :self.opy_mx5
                                     , 'i0'  :self.opy_shamt
                                     , 'i1'  :self.const_out
                                     , 'nq'  :self.opy_its5
                                     , 'vdd' :self.vdd
                                     , 'vss' :self.vss
                                     }
                             )
    self.y_ts5 = Inst( 'nbuse_b32', 'y_ts5'
                     , map = { 'cmd' :self.opy_ts5
                             , 'i0'  :self.opy_its5
                             , 'nq'  :self.opy_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.y_ts6 = Inst( 'buse_b32', 'y_ts6'
                     , map = { 'cmd' :self.opy_ts6
                             , 'i0'  :self.const_out
                             , 'q'   :self.opy_out
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )

   # ALU_i_N, ADR_N_i ET OUT_ADR i=0,1,31 
    self.inv_ir_ns = Inst( 'inv_d1_b32', 'inv_ir_ns'
                         , map = { 'i0'  :self.ir_s
                                 , 'nq'  :self.ir_ns
                                 , 'vdd' :self.vdd
                                 , 'vss' :self.vss
                                 }
                         )
    self.inv_rsdt_adr_alu = Inst( 'inv_b21', 'inv_rsdt_adr_alu'
                                , map = { 'i0'  :Cat(self.ir_ns[31]
                                                    ,self.ir_ns[25]
                                                    ,self.ir_ns[24]
                                                    ,self.ir_ns[23]
                                                    ,self.ir_ns[22]
                                                    ,self.ir_ns[21]
                                                    ,self.ir_ns[20]
                                                    ,self.ir_ns[19]
                                                    ,self.ir_ns[18]
                                                    ,self.ir_ns[17]
                                                    ,self.ir_ns[16]
                                                    ,self.ir_ns[15]
                                                    ,self.ir_ns[14]
                                                    ,self.ir_ns[13]
                                                    ,self.ir_ns[12]
                                                    ,self.ir_ns[11]
                                                    ,self.out_adr[1]
                                                    ,self.out_adr[0]
                                                    ,self.alu_out[31]
                                                    ,self.alu_out[1]
                                                    ,self.alu_out[0]
                                                    )
                                        , 'nq'  :self.rstd_adr_alu[20:0]
                                        , 'vdd' :self.vdd
                                        , 'vss' :self.vss
                                        }
                                )
    self.mux_adrout = Inst( 'mux2_b32', 'mux_adrout'
                          , map = { 'cmd' :self.out_mx0i0
                                  , 'i0'  :self.ad_s
                                  , 'i1'  :self.pc_s
                                  , 'q'   :self.out_adr
                                  , 'vdd' :self.vdd
                                  , 'vss' :self.vss
                                  }
                          )

   # ALU. Signals:
   #  alu_sum, alu_shout, alu_xor, alu_nand, alu_nor, alu_nul, alu_out, alu_outb_h, alu_outh_n
   #  out_mux1, out_mux2, out_mux3, out_mux4, out_mux5

   # Addition & Substraction.
    self.adder_sub = Inst( 'adsb2f_b32', 'adder_sub'
                         , map = { 'i0'     :self.opx_out
                                 , 'i1'     :self.opy_out
                                 , 'q'      :self.alu_sum
                                 , 'add_sub':self.alu_mx0i0
                                 , 'c31'    :self.alu_c31_n
                                 , 'c30'    :self.alu_c30_n
                                 , 'vdd'    :self.vdd
                                 , 'vss'    :self.vss
                                 }
                         )
    self.forshift = Inst( 'inv_b1', 'forshift'
                        , map = { 'i0' :self.alu_mx2i0
                                , 'nq' :self.alu_mx2i0_n
                                , 'vdd':self.vdd
                                , 'vss':self.vss
                                }
                        )
    self.forc31   = Inst( 'inv_b1', 'forc31'
                        , map = { 'i0' :self.alu_c31_n
                                , 'nq' :self.alu_c31
                                , 'vdd':self.vdd
                                , 'vss':self.vss
                                }
                        )
    self.forc30   = Inst( 'inv_b1', 'forc30'
                        , map = { 'i0' :self.alu_c30_n
                                , 'nq' :self.alu_c30
                                , 'vdd':self.vdd
                                , 'vss':self.vss
                                }
                        )

   # Shifts.
    self.ishifter = Inst( 'shifter_b32', 'ishifter'
                        , map = { 'op'   :Cat( self.alu_mx1i0, self.alu_mx2i0_n )
                                , 'shamt':self.opy_out[4:0]
                                , 'i'    :self.opx_out
                                , 'o'    :self.alu_shout
                                , 'vdd'  :self.vdd
                                , 'vss'  :self.vss
                                }
                        )
  
   # Logical bitwise operations.
    self.ixor = Inst( 'xor2_b32', 'ixor'
                    , map = { 'i0'  :self.opx_out
                            , 'i1'  :self.opy_out
                            , 'q'   :self.alu_xor
                            , 'vdd' :self.vdd
                            , 'vss' :self.vss
                            }
                    )
    self.inand = Inst( 'nand2_b32', 'inand'
                     , map = { 'i0'  :self.opx_out
                             , 'i1'  :self.opy_out
                             , 'nq'  :self.alu_nand
                             , 'vdd' :self.vdd
                             , 'vss' :self.vss
                             }
                     )
    self.inor = Inst( 'nor2_b32', 'inor'
                    , map = { 'i0'  :self.opx_out
                            , 'i1'  :self.opy_out
                            , 'nq'  :self.alu_nor
                            , 'vdd' :self.vdd
                            , 'vss' :self.vss
                            }
                    )

  # Zero detect.
    self.izero = Inst( 'nul_b32', 'izero'
                    , map = { 'i0'  :self.alu_sum
                            , 'nul' :self.alu_nul
                            , 'vdd' :self.vdd
                            , 'vss' :self.vss
                            }
                    )
   
   # ALU output bus.
    self.mux_out1 = Inst( 'nmux2_b32', 'mux_out1'
                        , map = { 'cmd' :self.alu_half
                                , 'i0'  :self.alu_out
                                , 'i1'  :Cat( self.alu_out[15:0], self.alu_out[15:0] )
                                , 'nq'  :self.data_outh_n
                                , 'vdd' :self.vdd
                                , 'vss' :self.vss
                                }
                        )
    self.mux_out2 = Inst( 'nmux2_b32', 'mux_out2'
                        , map = { 'cmd' :self.alu_byte
                                , 'i0'  :self.alu_out
                                , 'i1'  :Cat( self.alu_out[7:0]
                                            , self.alu_out[7:0]
                                            , self.alu_out[7:0]
                                            , self.alu_out[7:0] )
                                , 'nq'  :self.data_outb_n
                                , 'vdd' :self.vdd
                                , 'vss' :self.vss
                                }
                        )
    self.mux_out  = Inst( 'nmux2_b32', 'mux_out'
                        , map = { 'cmd' :self.alu_half
                                , 'i0'  :self.data_outb_n
                                , 'i1'  :self.data_outh_n
                                , 'nq'  :self.data_out_dpt
                                , 'vdd' :self.vdd
                                , 'vss' :self.vss
                                }
                        )

    self.mux_1    = Inst( 'nmux2_b32', 'mux_1'
                        , map = { 'cmd' :self.alu_mx1i2
                                , 'i0'  :self.alu_nand
                                , 'i1'  :self.alu_nor
                                , 'nq'  :self.out_mux1
                                , 'vdd' :self.vdd
                                , 'vss' :self.vss
                                }
                        )
    self.mux_2    = Inst( 'nmux2_b32', 'mux_2'
                        , map = { 'cmd' :self.alu_mx2i1
                                , 'i0'  :self.out_mux1
                                , 'i1'  :self.alu_xor
                                , 'nq'  :self.out_mux2
                                , 'vdd' :self.vdd
                                , 'vss' :self.vss
                                }
                        )
    self.mux_3    = Inst( 'nmux2_b32', 'mux_3'
                        , map = { 'cmd' :self.alu_mx2i1
                                , 'i0'  :self.alu_nor
                                , 'i1'  :self.alu_sum
                                , 'nq'  :self.out_mux3
                                , 'vdd' :self.vdd
                                , 'vss' :self.vss
                                }
                        )
    self.mux_4    = Inst( 'nmux2_b32', 'mux_4'
                        , map = { 'cmd' :self.alu_mx3i0
                                , 'i0'  :self.out_mux2
                                , 'i1'  :self.out_mux3
                                , 'nq'  :self.out_mux4
                                , 'vdd' :self.vdd
                                , 'vss' :self.vss
                                }
                        )
    self.mux_5    = Inst( 'nmux2_b32', 'mux_5'
                        , map = { 'cmd' :self.alu_mx4i0
                                , 'i0'  :self.alu_shout
                                , 'i1'  :self.out_mux4
                                , 'nq'  :self.out_mux5
                                , 'vdd' :self.vdd
                                , 'vss' :self.vss
                                }
                        )

    self.mux_6 = Inst( 'alutestn', 'mux_6'
                     , map = { 'alu_mx5i0' :self.alu_mx5i0
                             , 'alu_test_n':self.alu_test_n
                             , 'out_mux5'  :self.out_mux5
                             , 'alu_out'   :self.alu_out
                             , 'vdd'       :self.vdd
                             , 'vss'       :self.vss
                             }
                     )
  
    return


  def Layout ( self ):
   # Your placement here!

    return
