#!/usr/bin/env python

from stratus import *


class statcaus ( Model ):

  def Interface ( self ):
    self.crsr_sts_in = SignalIn ( "crsr_sts_in", 16 )
    self.opx_its3    = SignalOut( "opx_its3"   , 32 )
    self.vdd         = VddIn    ( "vdd" )
    self.vss         = VssIn    ( "vss" )
    return


  def Netlist ( self ):
    Generate( "DpgenInv"  , "inv_b16_d1"  , param = {'nbit':16, 'drive':1       ,  'physical' : True} )
    Generate( "DpgenConst", "const_0xffff", param = {'nbit':16, 'const':'0xFFFF',  'physical' : True} )

    self.inv = Inst( 'inv_b16_d1', 'inv'
                   , map = { 'i0' : self.crsr_sts_in
                           , 'nq' : self.opx_its3[15:0]
                           , 'vdd': self.vdd
                           , 'vss': self.vss
                           }
                   ) 

    self.const = Inst( 'const_0xffff', 'const'
                     , map = { 'q'  : self.opx_its3[31:16]
                             , 'vdd': self.vdd
                             , 'vss': self.vss
                             }
                     ) 
    return


  def Layout ( self ):
    Place( self.inv  , NOSYM, XY(0,0    ) )
    Place( self.const, NOSYM, XY(0,50*16) )
    return
