#!/usr/bin/env python

from stratus import *


class x_const ( Model ):

  def Interface ( self ):
    self.opx_mx4   = SignalIn ( "opx_mx4"  ,  1 )
    self.opx_ts5   = SignalIn ( "opx_ts5"  ,  1 )
    self.opx_ts6   = SignalIn ( "opx_ts6"  ,  1 )
    self.opx_ts7   = SignalIn ( "opx_ts7"  ,  1 )
    self.pc        = SignalIn ( "pc"       ,  4 ) # Should be connected to pc[31:28].
    self.const_out = SignalOut( "const_out", 32 )
    self.vdd       = VddIn    ( "vdd" )
    self.vss       = VssIn    ( "vss" )
    return


  def Netlist ( self ):
    self.mx_ts5   = Signal( 'mx_ts5'  , 1 )
    self.opx_mx_n = Signal( 'opx_mx_n', 1 )
    self.mx_n_ts7 = Signal( 'mx_n_ts7', 1 )
    self.pc3      = Signal( 'pc3'     , 1 )

    self.instances = []

   # bits 0-3.
    for i in range(0,7):
        self.instances += [ Inst( 'buf_x2', 'buf_%d'%i
                                , map = { 'i'  :self.opx_ts6
                                        , 'q'  :self.const_out[i]
                                        , 'vdd':self.vdd
                                        , 'vss':self.vss
                                        }
                                ) ]
   # bit 7 (uses slices 7 & 8).
    self.instances += [ Inst( 'a2_x2', 'a2_7'
                            , map = { 'i0' :self.opx_mx4
                                    , 'i1' :self.opx_ts5
                                    , 'q'  :self.mx_ts5
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'o2_x2', 'o2_8'
                            , map = { 'i0' :self.mx_ts5
                                    , 'i1' :self.opx_ts6
                                    , 'q'  :self.const_out[7]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
   # bits 8-15.
    for i in range(8,16):
        self.instances += [ Inst( 'buf_x2', 'buf_%d'%(i+1)
                                , map = { 'i'  :self.opx_ts6
                                        , 'q'  :self.const_out[i]
                                        , 'vdd':self.vdd
                                        , 'vss':self.vss
                                        }
                                ) ]
   # bits 16-27.
    for i in range(16,28):
        self.instances += [ Inst( 'zero_x0', 'zero_%d'%(i+1)
                                , map = { 'nq' :self.const_out[i]
                                        , 'vdd':self.vdd
                                        , 'vss':self.vss
                                        }
                                ) ]
   # bits 28-30.
    self.instances += [ Inst( 'inv_x1', 'inv_29'
                            , map = { 'i'  :self.opx_mx4
                                    , 'nq' :self.opx_mx_n
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'a2_x2', 'a2_30'
                            , map = { 'i0' :self.opx_mx_n
                                    , 'i1' :self.opx_ts7
                                    , 'q'  :self.mx_n_ts7
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    for i in range(28,31):
      self.instances += [ Inst( 'a2_x2', 'a2_%d'%(i+3)
                              , map = { 'i0' :self.mx_n_ts7
                                      , 'i1' :self.pc[i-28]
                                      , 'q'  :self.const_out[i]
                                      , 'vdd':self.vdd
                                      , 'vss':self.vss
                                      }
                              ) ]
   # bit 31.
    self.instances += [ Inst( 'a2_x2', 'a2_34'
                            , map = { 'i0' :self.mx_n_ts7
                                    , 'i1' :self.pc[3]
                                    , 'q'  :self.pc3
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    self.instances += [ Inst( 'o2_x2', 'o2_35'
                            , map = { 'i0' :self.mx_ts5
                                    , 'i1' :self.pc3
                                    , 'q'  :self.const_out[31]
                                    , 'vdd':self.vdd
                                    , 'vss':self.vss
                                    }
                            ) ]
    return


  def Layout ( self ):
   # Your placement here.
    return
