#!/usr/bin/env python

###############################################################
###                                                         ###
### File    : genmux.py                                     ###
### Date    : December 10 2009                              ###
### Version : 1.02                                          ###
### Author  : Belloeil Sophie                               ###
###                                                         ###
### Origin  : This description has been developed at LIP6   ###
###           University Paris 6 - Pierre et Marie Curie    ###
###           4 Place Jussieu 75252 Paris Cedex 05 - France ###
###                                                         ###
###############################################################

from stratus import *

from mux import mux

# Recuperation du parametre du script depuis la ligne de commande
n = Param ( "n" )

# Creation du dictionnaire des parametres
dict = { 'nbit' : n }

# Creation de l'instance mux avec les parametres definis par le dictionnaire dict
myMux = mux ( "mux_%d" % n, param = dict )

# Generation effective du mux avec l appel de ses deux methodes
myMux.Interface ()
myMux.Netlist ()

# Ecriture sur le disque de l'instance produite
myMux.Save ()
