#!/usr/bin/env python

###############################################################
###                                                         ###
### File    : mux2.py                                       ###
### Date    : December 10 2009                              ###
### Version : 1.02                                          ###
### Author  : Belloeil Sophie                               ###
###                                                         ###
### Origin  : This description has been developed at LIP6   ###
###           University Paris 6 - Pierre et Marie Curie    ###
###           4 Place Jussieu 75252 Paris Cedex 05 - France ###
###                                                         ###
###############################################################

from stratus import *

class mux ( Model ) :

  def Interface ( self ) :
    self.n = self._param['nbit']

    self.i0  = SignalIn  ( "i0", self.n )
    self.i1  = SignalIn  ( "i1", self.n )
    self.cmd = SignalIn  ( "cmd", 1 )
    self.s   = SignalOut ( "s", self.n )
    self.vdd = VddIn ( "vdd" )
    self.vss = VssIn ( "vss" )

  def Netlist ( self ) :
    for i in range ( self.n ) :
      Inst ( "mx2_x2"
           , map = { 'i0'  : self.i0[i]
                   , 'i1'  : self.i1[i]
                   , 'cmd' : self.cmd
                   , 'q'   : self.s[i]
                   , 'vdd' : self.vdd
                   , 'vss' : self.vss
                   }
           )

  # Description des patterns
  def Pattern ( self ) :
    pat = PatWrite ( self._name + '.pat', self )
   
    # Declaration de l interface 
    pat.declar (self.i0,  'X' )
    pat.declar (self.i1,  'X' )
    pat.declar (self.cmd, 'B' )
    pat.declar (self.s,   'X' )
    
    pat.declar (self.vdd, 'B' )
    pat.declar (self.vss, 'B' )

    pat.pattern_begin ()
    
    # Affectation des valeurs
    pat.affect_int ( self.vdd, 1 )
    pat.affect_int ( self.vss, 0 )
    
    for i0 in range ( self.n ) :
      for i1 in range ( self.n ) :
        for c in range ( 2 ) :
          pat.affect_int ( self.i0,  i0 )
          pat.affect_int ( self.i1,  i1 )
          pat.affect_int ( self.cmd,  c )

          if c == 1 : pat.affect_int ( self.s, i1 )
          else      : pat.affect_int ( self.s, i0 )

          # Ajout du pattern
          pat.addpat ()

    del pat
