#!/usr/bin/env python

###############################################################
###                                                         ###
### File    : mux.py                                        ###
### Date    : December 10 2009                              ###
### Version : 1.02                                          ###
### Author  : Belloeil Sophie                               ###
###                                                         ###
### Origin  : This description has been developed at LIP6   ###
###           University Paris 6 - Pierre et Marie Curie    ###
###           4 Place Jussieu 75252 Paris Cedex 05 - France ###
###                                                         ###
###############################################################

from stratus import *

# Definition du bloc mux
class mux ( Model ) :

  # Declaration des connecteurs
  def Interface ( self ) :
    # Recuperation du parametre 'nbit'
    self.n = self._param['nbit']

    # Connecteurs
    self.i0  = SignalIn  ( "i0", self.n )
    self.i1  = SignalIn  ( "i1", self.n )
    self.cmd = SignalIn  ( "cmd", 1 )
    self.s   = SignalOut ( "s", self.n )
    self.vdd = VddIn ( "vdd" )
    self.vss = VssIn ( "vss" )

  # Instanciation des cellules
  def Netlist ( self ) :
    # Boucle for utilisant le parametre
    for i in range ( self.n ) :
      Inst ( "mx2_x2"
           , map = { 'i0'  : self.i0[i]
                   , 'i1'  : self.i1[i]
                   , 'cmd' : self.cmd
                   , 'q'   : self.s[i]
                   , 'vdd' : self.vdd
                   , 'vss' : self.vss
                   }
           )
