
char getchar(void);

/* #define UART_BUFSIZE 16 */
/* #define UART_BUFSIZE_MASK 0x0f */
#define UART_BUFSIZE 128
#define UART_BUFSIZE_MASK 0x7f

extern char uart_txbuf[UART_BUFSIZE];
extern unsigned char uart_txbuf_prod;
extern volatile unsigned char uart_txbuf_cons;

extern char uart_rxbuf[UART_BUFSIZE];
extern volatile unsigned char uart_rxbuf_prod;
extern unsigned char uart_rxbuf_cons;

char uart_getchar(void);
void uart_putchar_raw(char);
#if 0
#define UART_PUTCHAR_HARD(c) { \
	while (PIR1bits.TX1IF == 0) \
		; \
	TXREG1 = c; \
}
#endif
void uart_putchar_hard(char) __wparam;

#define UART_FLUSH() { \
        while (PIE1bits.TX1IE) \
		; \
}
	

#define USART_INIT { \
		uart_txbuf_prod = uart_txbuf_cons = 0; \
		uart_rxbuf_prod = uart_rxbuf_cons = 0; \
		(void)RCREG1; \
		PIE1bits.RC1IE = 1; \
	}

#define USART_INTR {\
	if (PIE1bits.TX1IE && PIR1bits.TX1IF) { \
		if (uart_txbuf_prod == uart_txbuf_cons) { \
			PIE1bits.TX1IE = 0; /* buffer empty */ \
		} else { \
			/* Place char in TXREG - this starts transmition */ \
			TXREG1 = uart_txbuf[uart_txbuf_cons]; \
			uart_txbuf_cons = (uart_txbuf_cons + 1) & UART_BUFSIZE_MASK;\
		} \
	} \
	if (PIE1bits.RC1IE && PIR1bits.RC1IF) { \
		register char c = RCREG1; \
		if (RCSTA1bits.OERR) { \
			RCSTA1bits.CREN = 0; \
			RCSTA1bits.CREN = 1; \
		} \
		if (status & STAT_CONSOLE) { \
			uart_rxbuf_prod = (uart_rxbuf_prod + 1) & UART_BUFSIZE_MASK;\
			uart_rxbuf[uart_rxbuf_prod] = c; \
		} else { \
			if (c == '\r') c = '\n';\
			if (c != '\n' || uart_rxbuf[uart_rxbuf_prod] != '\n') { \
				uart_rxbuf_prod = (uart_rxbuf_prod + 1) & UART_BUFSIZE_MASK;\
				uart_rxbuf[uart_rxbuf_prod] = c; \
				if (c == '\n') { \
					if (softintrs & INT_RX1) \
						softintrs |= INT_RX1OF; \
					softintrs |= INT_RX1; \
				} \
			} \
		} \
	}\
    }
