#include <pic18fregs.h>
#include <stdio.h>
#include <my_serial.h>

char uart_txbuf[UART_BUFSIZE];
unsigned char uart_txbuf_prod;
volatile unsigned char uart_txbuf_cons;

char uart_rxbuf[UART_BUFSIZE];
volatile unsigned char uart_rxbuf_prod;
unsigned char uart_rxbuf_cons;

#define LEDR LATAbits.LATA7

PUTCHAR(c) /* Macro */
{
	unsigned char new_uart_txbuf_prod;
#if 0
	if  (!PORTBbits.RB7)
		return;
#endif
	new_uart_txbuf_prod = (uart_txbuf_prod + 1) & UART_BUFSIZE_MASK;
#if 1

again:
        while (new_uart_txbuf_prod == uart_txbuf_cons) {
		PIE1bits.TX1IE = 1; /* ensure we'll make progress */
	}
	uart_txbuf[uart_txbuf_prod] = c;
	uart_txbuf_prod = new_uart_txbuf_prod;
	PIE1bits.TX1IE = 1;
	if (c == '\n') {
		c = '\r';
		new_uart_txbuf_prod = (uart_txbuf_prod + 1) & UART_BUFSIZE_MASK;
		goto again;
	}
#else
again:
	while (!PIR1bits.TX1IF)
		; /* wait */
	TXREG1 = c;
	if (c == '\n') {
		c = '\r';
		goto again;
	}
#endif
}

void
uart_putchar_raw(char c)
{
	unsigned char new_uart_txbuf_prod;
	new_uart_txbuf_prod = (uart_txbuf_prod + 1) & UART_BUFSIZE_MASK;
        while (new_uart_txbuf_prod == uart_txbuf_cons) {
		PIE1bits.TX1IE = 1; /* ensure we'll make progress */
	}
	uart_txbuf[uart_txbuf_prod] = c;
	uart_txbuf_prod = new_uart_txbuf_prod;
	PIE1bits.TX1IE = 1;
}

void
uart_putchar_hard(char c) __wparam {
	while (PIR1bits.TX1IF == 0)
		;
	TXREG1 = c;
}

char
getchar(void)
{
	char c;
	char en;
	en = PIE1bits.RC1IE;
	PIE1bits.RC1IE = 0;
	while (!PIR1bits.RC1IF); /* wait for a char */
	c = RCREG1;
	if (RCSTA1bits.OERR) {
		RCSTA1bits.CREN = 0;
		RCSTA1bits.CREN = 1;
	}
	PIE1bits.RC1IE = en;
	return c;
}

char
uart_getchar()
{
	register char c;
	LEDR = 1;
	while (uart_rxbuf_cons == uart_rxbuf_prod)
		;

	uart_rxbuf_cons = (uart_rxbuf_cons + 1) & UART_BUFSIZE_MASK;
	c = uart_rxbuf[uart_rxbuf_cons];
	LEDR = 0;
	return c;
}
