#include <pic18fregs.h>
#include <stdio.h>
#include <my_serial2.h>

char uart2_txbuf[UART2_BUFSIZE];
unsigned char uart2_txbuf_prod;
volatile unsigned char uart2_txbuf_cons;

char uart2_rxbuf[UART2_BUFSIZE];
volatile unsigned char uart2_rxbuf_prod;
unsigned char uart2_rxbuf_cons;

void
uart2_putchar_raw(char c)
{
	unsigned char new_uart2_txbuf_prod;
	new_uart2_txbuf_prod = (uart2_txbuf_prod + 1) & UART2_BUFSIZE_MASK;
        while (new_uart2_txbuf_prod == uart2_txbuf_cons) {
		PIE3bits.TX2IE = 1; /* ensure we'll make progress */
	}
	uart2_txbuf[uart2_txbuf_prod] = c;
	uart2_txbuf_prod = new_uart2_txbuf_prod;
	PIE3bits.TX2IE = 1;
}

char
uart2_getchar()
{
	register char c;
	while (uart2_rxbuf_cons == uart2_rxbuf_prod)
		;

	uart2_rxbuf_cons = (uart2_rxbuf_cons + 1) & UART2_BUFSIZE_MASK;
	c = uart2_rxbuf[uart2_rxbuf_cons];
	return c;
}
