
char getchar(void);

#define UART2_BUFSIZE 16
#define UART2_BUFSIZE_MASK 0x0f

extern char uart2_txbuf[UART2_BUFSIZE];
extern unsigned char uart2_txbuf_prod;
extern volatile unsigned char uart2_txbuf_cons;

extern char uart2_rxbuf[UART2_BUFSIZE];
extern volatile unsigned char uart2_rxbuf_prod;
extern unsigned char uart2_rxbuf_cons;

char uart2_getchar(void);
void uart2_putchar_raw(char);

#define USART2_INIT { \
		uart2_txbuf_prod = uart2_txbuf_cons = 0; \
		uart2_rxbuf_prod = uart2_rxbuf_cons = 0; \
		(void)RCREG2; \
		PIE3bits.RC2IE = 1; \
	}

#define USART2_INTR {\
	if (PIE3bits.TX2IE && PIR3bits.TX2IF) { \
		if (uart2_txbuf_prod == uart2_txbuf_cons) { \
			PIE3bits.TX2IE = 0; /* buffer empty */ \
		} else { \
			/* Place char in TXREG - this starts transmition */ \
			TXREG2 = uart2_txbuf[uart2_txbuf_cons]; \
			uart2_txbuf_cons = (uart2_txbuf_cons + 1) & UART2_BUFSIZE_MASK;\
		} \
	} \
	if (PIE3bits.RC2IE && PIR3bits.RC2IF) { \
		register char c = RCREG2; \
		if (RCSTA2bits.OERR) { \
			RCSTA2bits.CREN = 0; \
			RCSTA2bits.CREN = 1; \
		} \
		uart2_rxbuf_prod = (uart2_rxbuf_prod + 1) & UART2_BUFSIZE_MASK;\
		uart2_rxbuf[uart2_rxbuf_prod] = c; \
	}\
    }
