#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <err.h>
#include <fcntl.h>
#include <signal.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <sys/select.h>

volatile int quit;
const char *prog;

static void
set_quit(int s)
{
	quit = 1;
}

static void
usage()
{
	errx(1, "usage: %s <device> <cmd>", prog);
}

static void
readline(int d, char *buf, int l)
{
	int i;
	int bytes;
	do {
		for (i = 0; i < l; i++) {
			do {
				bytes = read(d, &buf[i], 1);
				if (quit)
					return;
			} while ((bytes < 0 && errno == EAGAIN) || buf[i] == '\r');
			if (bytes != 1) {
				fprintf(stderr, "readline: read %d\n", bytes);
				err(1, "read line");
			}
			if (buf[i] == '\n')
				break;
		}
	} while (i == 0);
	if (buf[i] != '\n') {
		warnx("realine: end of line not found");
	}
	buf[i] = '\0';
}

int
main(int argc, char * const argv[])
{
	int d;
	int bytes;
	int nfds;
	int lineno = 0;
	char buf[256];
	int i;
	fd_set rfds;
	char *endp;
	int gpioi, currenti, tensioni;
	float current_a, tension_v;
	int val, gpio_val;
	int c_opt = 0, v_opt = 0;
        extern char *optarg;
	extern int optind;
	int ch;

	struct termios t, ot;

	prog = argv[0];
	argc -= 1;
	argv += 1;

	if (argc != 2)
		usage();

	d = open(argv[0], O_RDWR | O_NOCTTY | O_NONBLOCK, 0);
	if (d < 0) {
		err(1, "open %s", argv[0]);
	}

	if (tcgetattr(d, &ot) < 0) {
		err(1, "tcgetattr");
	}

	quit = 0;

	if (signal(SIGINT, set_quit) == SIG_ERR) {
		err(1, "signal(SIGINT)");
	}
	if (signal(SIGQUIT, set_quit) == SIG_ERR) {
		err(1, "signal(SIGQUIT)");
	}
	if (signal(SIGPIPE, set_quit) == SIG_ERR) {
		err(1, "signal(SIGPIPE)");
	}
	if (signal(SIGTERM, set_quit) == SIG_ERR) {
		err(1, "signal(SIGTERM)");
	}

	t = ot;
	cfmakeraw(&t);
	t.c_cflag |= CLOCAL;
	t.c_cflag &= ~CRTSCTS;
	cfsetspeed(&t, B921600);

	if (tcsetattr(d, TCSANOW | TCSAFLUSH, &t) < 0) {
		err(1, "tcsetattr");
	}
	do {
		write(d, "M0\n", 3);
		readline(d, buf, sizeof(buf));
		if (quit)
			goto quit;
	} while (memcmp(buf, "OK", 2) != 0);

	snprintf(buf, sizeof(buf) - 1, "%s\n", argv[1]);
	write(d, buf, strlen(buf));
	readline(d, buf, sizeof(buf));
	if (quit)
		goto quit;
	printf("%s\n", buf);
quit:
	if (fflush(stdout) == EOF) {
		warn("fflush");
	}
	if (tcsetattr(d, TCSANOW, &ot) < 0) {
		err(1, "restore tcsetattr");
	}
	exit(0);
}
