#include <pic18fregs.h>
#include <stdio.h>
#include <my_serial.h>

char uart_txbuf[UART_BUFSIZE];
unsigned char uart_txbuf_prod;
volatile unsigned char uart_txbuf_cons;

PUTCHAR(c) /* Macro */
{
	unsigned char new_uart_txbuf_prod;
#if 0
	if  (!PORTBbits.RB7)
		return;
#endif
	new_uart_txbuf_prod = (uart_txbuf_prod + 1) & UART_BUFSIZE_MASK;
#if 1

again:
        while (new_uart_txbuf_prod == uart_txbuf_cons) {
		PIE1bits.TX1IE = 1; /* ensure we'll make progress */
	}
	uart_txbuf[uart_txbuf_prod] = c;
	uart_txbuf_prod = new_uart_txbuf_prod;
	PIE1bits.TX1IE = 1;
	if (c == '\n') {
		c = '\r';
		new_uart_txbuf_prod = (uart_txbuf_prod + 1) & UART_BUFSIZE_MASK;
		goto again;
	}
#else
again:
	while (!PIR1bits.TX1IF)
		; /* wait */
	TXREG1 = c;
	if (c == '\n') {
		c = '\r';
		goto again;
	}
#endif
}

char
getchar(void)
{
	char c;
	while (!PIR1bits.RC1IF); /* wait for a char */
	c = RCREG1;
	if (RCSTA1bits.OERR) {
		RCSTA1bits.CREN = 0;
		RCSTA1bits.CREN = 1;
	}
	return c;
}
