
char getchar(void);

/* #define UART_BUFSIZE 16 */
/* #define UART_BUFSIZE_MASK 0x0f */
#define UART_BUFSIZE 128
#define UART_BUFSIZE_MASK 0x7f

extern char uart_txbuf[UART_BUFSIZE];
extern unsigned char uart_txbuf_prod;
extern volatile unsigned char uart_txbuf_cons;

#define USART_INIT { \
		uart_txbuf_prod = uart_txbuf_cons = 0; \
	}

#define USART_INTR {\
	if (PIE1bits.TX1IE && PIR1bits.TX1IF) { \
		if (uart_txbuf_prod == uart_txbuf_cons) { \
			PIE1bits.TX1IE = 0; /* buffer empty */ \
		} else { \
			/* Place char in TXREG - this starts transmition */ \
			TXREG1 = uart_txbuf[uart_txbuf_cons]; \
			uart_txbuf_cons = (uart_txbuf_cons + 1) & UART_BUFSIZE_MASK;\
		} \
	} \
    }
