#include "processing_queue.h"

void ProcessingQueue::insert(const Address addr, unsigned int latency)
{
    ProcessingElement el = 
    { 
        addr, 
        INTERNAL_TIMEOUT,
        false,
        latency 
    };
    elements.push_back(el);
}

void ProcessingQueue::insert(const Address addr)
{
    ProcessingElement el = 
    {
        addr,
        EXTERNAL_WAIT,
        false,
        0
    };
    elements.push_back(el);
}

void ProcessingQueue::update_time()
{
    list<ProcessingElement>::iterator it;
    for (it = elements.begin(); it != elements.end(); it++) {
        if (it->processing_type == INTERNAL_TIMEOUT) {
            if (it->latency > 0){
                it->latency--;
            } else {
                // FIXME readd this test
                // cout << "latency going under 0" << endl;
            }
        }
    }
}

bool ProcessingQueue::is_empty()
{
    return elements.empty();
}


void ProcessingQueue::mark_ready(Address &element)
{
    /*
    list<ProcessingElement>::iterator it;
    for (it=elements.begin(); it!= elements.end(); it++) {
        ProcessingElement el = *it;
        if (el.address == element) {
            if (el.processing_type == EXTERNAL_WAIT) {
                el.is_ready = true;
            } else {
                //cout << "marking duplicate or incorrect element as ready" << endl;
            }
        }
    }*/
}

Address* ProcessingQueue::get_next_ready()
{
    
     //cout << "appel a get_next_ready" << endl;
    list<ProcessingElement>::iterator it;
    for (it=elements.begin(); it!= elements.end(); it++) {
        if (it->processing_type == EXTERNAL_WAIT) {
            if (it->is_ready == true) {
                 //cout << "suppression de l'element : " << el;
                elements.erase(it);
                return &(it->address);
            } else {
                 //cout << "get_next_ready incorrect behavior" << endl;
                exit (5439405);
            }
        } else {
             //cout << "l'element est en internal timeout" << endl;
            if (it->latency == 0){
                 //cout << "suppression de l'element" << *it << endl;
                elements.erase(it);
                return &(it->address);
            }
        }
    }
     //cout << "retour de get_next_ready : null" << endl;
     
    return NULL;
}

/*
int ProcessingQueue::get_ready_element() {
    list<ProcessingElement>::iterator it;
    it = elements.begin();
    ProcessingElement el = *it;
    if (el.current_latency != timer) {
         //cout << "please use has_ready_element before. Aborting" << endl;
        exit (-123213);
    } else {
        elements.pop_front();
        return el.address;
    }
}
*/
/*
bool ProcessingQueue::has_ready_element() 
{
    list<ProcessingElement>::iterator it;
    it = elements.begin();
    if (elements.size() == 0)
        return false;

    ProcessingElement el = *it;
    if (el.current_latency == timer) {
        return true;
    } else {
        return false;
    }
}
*/
void ProcessingQueue::print()
{
    cout << "\t" << "Processing QUEUE START" << endl;

    for(list<ProcessingElement>::iterator it=elements.begin(); it!=elements.end(); it++)
    {
        cout << "\t\t" << "element : " << *it << endl;
    }

    cout << "\t" << "Processing QUEUE STOP" << endl;
}
