#include "processor.h"


// Pilote du simulateur
// lit une addresse dans un fichier si il y a encore des addresses
//  lire et si la file d'attente n'est pas pleine
void Processor::driver()
{
    out_activate = false;

    // Si il y a encore des addresses  envoyer
    if (!file.eof()) {

        // Et que la file n'est pas pleine, alors on les envoie
        if (!queue->is_full()) {

            // Vide pour l'instant, c'est la donne a charger
            int data;
            
            // RawAddresse  charger dans le cache...
            unsigned int address;

            // Lecture de l'addresse depuis le fichier
            file >> address;
            
            if (file.eof()){
                return;
            }

            cout << "lecture de " << dec << address << " dans le fichier" << endl;

            RawAddress *addr = new RawAddress(address);

            // Si il y a encore des addresses  envoyer
            cout << sc_time_stamp() << " Processor : request " << *addr << endl;

            // on ajoute la requete a la queue
            queue->insert(*addr);

            // Lecture :
            out_data = address;
            out_activate = true;
            read(*addr, &data);

        }
        //
        // Si la file est pleine, il faudra attendre un cycle dans la mme
        // position
    }
}

// Est appele lorsqu'une rponse depuis le cache L1 est envoye.
void Processor::completed()
{
    if (in_activate) {
        cout << "processeur activ" << endl;
        cout << sc_time_stamp() << " Processor : la donne " << in_data << " est arrive" << endl;
        //queue->print();
        RawAddress address = in_data;
        queue->remove(address);
        cout << "--------------- processeur : tat de la queue : " << endl;
        queue->print();
    }
}

void Processor::read(RawAddress &address, int *value)
{
    // ici, if ready
    out_data = address;
    out_activate = true;
}

void Processor::write(RawAddress &address, int value)
{
    // ici, if ready
    out_data = address;
}
