#include "processor.h"
#include "l1cache.h"
#include "address.h"
#include "raw_address.h"
#include "monitor.h"
#include "cache_store.h"
#define TAILLE_LIGNE 8

int sc_main(int argc, char **argv)
{
    if (argc != 2) {
        cout << "usage : " << argv[0] << " filename" << endl;
        exit(0);
    }

    sc_clock clock("Clock", 1,SC_NS); 

    sc_signal<RawAddress> request;
    sc_signal<RawAddress> answer;

    sc_signal<bool> l1_activate;
    sc_signal<bool> proc_activate;

    sc_signal<bool> l1miss_info;
    sc_signal<bool> l1hit_info;

    sc_signal<bool> make_report;

    Processor processor("Processor", argv[1]);
    L1Cache   l1cache("L1Cache", 256, TAILLE_LIGNE, FULLY_ASSOCIATIVE, 2);
    Monitor   monitor("Monitor");

    processor.clock(clock);
    l1cache.clock(clock);
    monitor.clock(clock);

    l1cache.in_activate(l1_activate);
    processor.out_activate(l1_activate);

    l1cache.out_activate(proc_activate);
    processor.in_activate(proc_activate);

    processor.out_data(request);
    l1cache.in_data(request);

    processor.in_data(answer);
    l1cache.out_data(answer);


    processor.simulation_terminate(make_report);
    monitor.activate(make_report);

    l1cache.hit_info(l1hit_info);
    monitor.l1hit_signal(l1hit_info);

    l1cache.miss_info(l1miss_info);
    monitor.l1miss_signal(l1miss_info);



    sc_start(1000, SC_NS);
    return 0;
}
