#ifndef CPU_REQ_H_
#define CPU_REQ_H_

#include <systemc.h>
#include <iostream>
#include <iomanip>

class RawAddress {

    public:
        unsigned int address;

    RawAddress (const unsigned int address = 0) {
        this->address = address;
    }

    inline bool operator == (const RawAddress& rhs) const {
        return (rhs.address == address);
    }

    inline RawAddress& operator = (const RawAddress& rhs) {
        address = rhs.address;
        return *this;
    }
    

    inline friend void sc_trace(sc_trace_file *tf, const RawAddress & v, const std::string & NAME ) {
        // FIXME
    }


    inline friend ostream& operator << ( ostream& os,  RawAddress const & v ) {
        os << "0x" << hex << std::setfill('0') << std::setw(8) <<  v.address ;
        return os;
    }
    
    inline bool operator < (const RawAddress& rhs) const {
        return (rhs.address < address);
    }
};


#endif
