#include "l2cache.h"

void L2Cache::read()
{
    // On donne la priorité aux éléments en attente :
    //      - si des éléments sont présents dans la file d'attente
    //          on les envoie
    //      - TODO on doit pouvoir les packer pour pouvoir les envoyer par deux
    //      - si aucun élément n'est présent dans la liste, on arrête d'envoyer (in_activate = false)
    // indépendemment,
    //      - si on recoit un élement, on regarde s'il est chargé dans le cache:
    //          - si il est chargé, on le place dans la liste des addresses à envoyer,
    //              on attend un moment timeout avant de l'envoyer
    //          - si il n'est pas chargé, on envoit une requete au cache L2,
    //              on le place dans la liste des addresses à envoyer.
    //      - XXX le timeout devrait peut etre etre effectué, meme pour les données non présentes dans le L1

    miss_info = false;
    hit_info = false;

    if (in_activate) {

        // Retrieves the request address
        RawAddress req = in_data;
        Address element(req, cstore->get_line_width());

        // Si la donnée est chargée dans le cache
        if (cstore->is_loaded(element)) {
            
            out_activate = true;

            // affichage de l'action
            cout << sc_time_stamp() << " L2Cache : access to loaded data [" <<
                element << "]  -> hit" << endl;


            hit_info = true;
            out_data = in_data;
        } else {

            // affichage de l'action
            cout << sc_time_stamp() << " L2Cache : access to loaded data [" <<
                element << "]  -> miss" << endl; 

            miss_info = true;
            processing_queue->insert(element, latency);
            processing_queue->print();
        }
    }

    Address *head = processing_queue->get_next_ready(); 
    if (head != NULL)
    {
        cout << "has ready elements " << endl;
        //processing_queue->print();

        cstore->do_load(*head);

        // Envoi de la réponse au processeur
        RawAddress req(head->as_absolute());
        out_activate = true;
        out_data = req;
    } else if (! in_activate) {
        out_activate = false;
    }

    processing_queue->update_time();
    
}


void L2Cache::write()
{
    // cout << sc_time_stamp() << " L2Cache.write()" << endl;
}
