#include <systemc.h>

SC_MODULE(Monitor)
{
    int l1misses;
    int l1hits;

    //sc_in<bool> make_report;

    sc_in<bool> l1miss_signal;
    sc_in<bool> l1hit_signal;
    sc_in_clk clock;

    void count_hit();
    void count_miss();
    void make_my_report();

    SC_CTOR(Monitor)
    {
        l1misses = 0;
        l1hits = 0;

        SC_METHOD(make_my_report);
        sensitive << clock;

        SC_METHOD(count_hit);
        sensitive << clock.neg();

        SC_METHOD(count_miss);
        sensitive << clock.neg();
    }
};
