/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2006 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 2.4 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  sc_buffer.h -- The sc_buffer<T> primitive channel class.
                 Like sc_signal<T>, but *every* write causes an event.

  Original Author: Martin Janssen, Synopsys, Inc., 2001-05-21

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:
    
 *****************************************************************************/
//$Log: sc_buffer.h,v $
//Revision 1.1.1.1  2006/12/15 20:31:35  acg
//SystemC 2.2
//
//Revision 1.8  2006/03/13 20:19:43  acg
// Andy Goodrich: changed sc_event instances into pointers to sc_event instances
// that are allocated as needed. This saves considerable storage for large
// numbers of signals, etc.
//
//Revision 1.7  2006/01/26 21:00:49  acg
// Andy Goodrich: conversion to use sc_event::notify(SC_ZERO_TIME) instead of
// sc_event::notify_delayed()
//
//Revision 1.6  2006/01/24 20:46:31  acg
//Andy Goodrich: changes to eliminate use of deprecated features. For instance,
//using notify(SC_ZERO_TIME) in place of notify_delayed().
//
//Revision 1.5  2006/01/19 19:18:25  acg
//Andy Goodrich: eliminated check_writer in favor of inline code within the
//write() method since we always execute the check_writer code even when
//check writing is turned off.
//
//Revision 1.4  2006/01/19 00:30:57  acg
//Andy Goodrich: Yet another implementation for disabling write checks on
//signals. This version uses an environment variable, SC_SIGNAL_WRITE_CHECK,
//that when set to DISABLE will turn off write checking.
//
//Revision 1.3  2006/01/13 18:47:20  acg
//Reversed sense of multiwriter signal check. It now defaults to ON unless the
//user defines SC_NO_WRITE_CHEK before inclusion of the file.
//
//Revision 1.2  2006/01/03 23:18:26  acg
//Changed copyright to include 2006.
//
//Revision 1.1.1.1  2005/12/19 23:16:43  acg
//First check in of SystemC 2.1 into its own archive.
//
//Revision 1.9  2005/06/10 22:43:55  acg
//Added CVS change log annotation.
//

#ifndef SC_BUFFER_H
#define SC_BUFFER_H


#include "sysc/communication/sc_signal.h"

namespace sc_core {

// ----------------------------------------------------------------------------
//  CLASS : sc_buffer<T>
//
//  The sc_buffer<T> primitive channel class.
// ----------------------------------------------------------------------------

template <class T>
class sc_buffer
: public sc_signal<T>
{
public:

    // typedefs

    typedef sc_buffer<T> this_type;
    typedef sc_signal<T> base_type;

public:

    // constructors

    sc_buffer()
	: base_type( sc_gen_unique_name( "buffer" ) )
	{}

    explicit sc_buffer( const char* name_ )
	: base_type( name_ )
	{}


    // interface methods

    // write the new value
    virtual void write( const T& );


    // other methods

    sc_buffer<T>& operator = ( const T& a )
	{ write( a ); return *this; }

    sc_buffer<T>& operator = ( const base_type& a )
	{ write( a.read() ); return *this; }

    sc_buffer<T>& operator = ( const this_type& a )
	{ write( a.read() ); return *this; }

    virtual const char* kind() const
        { return "sc_buffer"; }

protected:

    virtual void update();

private:

    // disabled
    sc_buffer( const sc_buffer<T>& );
};


// IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII

// write the new value

template <class T>
inline
void
sc_buffer<T>::write( const T& value_ )
{
    sc_object* writer = sc_get_curr_simcontext()->get_current_writer();
    if( sc_signal<T>::m_writer == 0 ) {
	sc_signal<T>::m_writer = writer;
    } else if( sc_signal<T>::m_writer != writer ) {
	sc_signal_invalid_writer( this, sc_signal<T>::m_writer, writer );
    }

    this->m_new_val = value_;
    this->request_update();
}


template <class T>
inline
void
sc_buffer<T>::update()
{
    this->m_cur_val = this->m_new_val;
    if ( sc_signal<T>::m_change_event_p )
	    sc_signal<T>::m_change_event_p->notify(SC_ZERO_TIME);
    this->m_delta = sc_delta_count();
}

} // namespace sc_core

#endif

// Taf!
