#include "l1cache.h"


void L1Cache::read()
{
    // On donne la priorit aux lments en attente :
    //      - si des lments sont prsents dans la file d'attente
    //          on les envoie
    //      - TODO on doit pouvoir les packer pour pouvoir les envoyer par deux
    //      - si aucun lment n'est prsent dans la liste, on arrte d'envoyer (in_activate = false)
    // indpendemment,
    //      - si on recoit un lement, on regarde s'il est charg dans le cache:
    //          - si il est charg, on le place dans la liste des addresses  envoyer,
    //              on attend un moment timeout avant de l'envoyer
    //          - si il n'est pas charg, on envoit une requete au cache L2,
    //              on le place dans la liste des addresses  envoyer.
    //      - XXX le timeout devrait peut etre etre effectu, meme pour les donnes non prsentes dans le L1

    miss_info = false;
    hit_info = false;

    if (in_activate) {

        // Retrieves the address
        RawAddress req = in_data;
        Address element(req, cstore->get_line_width());

        // Si la donne est charge dans le cache
        if (cstore->is_loaded(element)) {
            
            out_activate = true;

            // affichage de l'action
            cout << sc_time_stamp() << " L1Cache : access to loaded data [" << element << "]  -> hit" << endl;


            hit_info = true;
            out_data = in_data;
        } else {

            // affichage de l'action
            cout << sc_time_stamp() << " L1Cache : access to loaded data [" << element << "]  -> miss" << endl; 

            miss_info = true;
            processing_queue->insert(element, latency);
            processing_queue->print();
        }
    }

    Address *head = processing_queue->get_next_ready(); 
    if (head != NULL)
    {
        cout << "has ready elements " << endl;
        //processing_queue->print();

        cstore->do_load(*head);

        // Envoi de la rponse au processeur
        RawAddress req(head->as_absolute());
        out_activate = true;
        out_data = req;
    } else if (! in_activate) {
        out_activate = false;
    }

    processing_queue->update_time();
    
}


void L1Cache::write()
{
    // cout << sc_time_stamp() << " L1Cache.write()" << endl;
}
