#include <systemc.h>
#include "util.h"
#include "queue.h"
#include "address.h"
#include "raw_address.h"

/*
 * Module reprsentant le processeur.  
 *
 * Il est charg,  chaque tick d'horloge d'envoyer des requtes au cache L1
 * qu'il lit dans un fichier spcifi au constructeur.
 */

SC_MODULE(Processor)
{
    // Horloge
    sc_in_clk clock;

    // File de 10 lements correspondant aux requetes ayant t envoyes et
    // dont on attend la rponse.  Si elle est pleine, le processeur devra
    // attendre qu'elle se vide avant de pouvoir envoyer d'autres requetes.
    Queue<RawAddress> *queue;

    // donne  envoyer au cache L1
    sc_out<RawAddress> out_data;
    sc_out<bool> out_activate;

    // donne retourne par le cache L1
    sc_in <RawAddress> in_data;
    sc_in <bool> in_activate;
   

    void driver();

    void read(RawAddress &address, int *value);
    void write(RawAddress &address, int value);

    void completed();

    ifstream file;

    Processor(sc_module_name name, char *filename) : sc_module(name)
    {
        // Initialisation
        this->queue = new Queue<RawAddress>(10);

        file.open(filename, ios::in);
        if (file.bad()) {
            cerr << "error opening file";
            exit (1);   // Erreur a l'ouverture, on quitte... violemment ...
        }

        // SystemC methods declarations
        SC_METHOD(driver);
        dont_initialize();
        sensitive << clock.pos();

        SC_METHOD(completed);
        dont_initialize();
        sensitive << clock.pos();
    };

    SC_HAS_PROCESS(Processor);

    ~Processor() {
        delete queue;
    }
};

