#include "processor.h"

void Processor::driver()
{
    // Si il y a encore des addresses  envoyer
    if (!file.eof()) {

        // On active le composant recepteur
        out_activate = true;

        // Et que la file n'est pas pleine, alors on les envoie
        if (!queue->is_full()) {

            // Vide pour l'instant, c'est la donne a charger
            int data;
            
            // RawAddresse  charger dans le cache...
            unsigned int address;

            // Lecture de l'addresse depuis le fichier
            file >> address;
            
            if (file.eof()){
                out_activate = false;
                return;
            }

            cout << "lecture de " << dec << address << " dans le fichier" << endl;

            RawAddress *addr = new RawAddress(address);

            // Si il y a encore des addresses  envoyer
            cout << sc_time_stamp() << " Processor : request " << *addr << endl;

            // on ajoute la requete a la queue
            queue->insert(*addr);

            read(*addr, &data);
        }
        // Si la file est pleine, il faudra attendre un cycle dans la mme
        // position
    }
    // Si il n'y a plus d'addresses  envoyer, on dsactive la rception du
    // cot cache l1.
    else {
        // FIXME normalement, c'est superflu
        // on dsactive la reception du cot du cache L1
        out_activate = false;
    }
}

void Processor::completed()
{
    if (in_activate) {
        cout << sc_time_stamp() << " Processor : la donne " << in_data << " est arrive" << endl;
        //queue->print();
        RawAddress address = in_data;
        queue->remove(address);
    }
}

void Processor::read(RawAddress &address, int *value)
{
    // ici, if ready
    out_data = address;
}

void Processor::write(RawAddress &address, int value)
{
    // ici, if ready
    out_data = address;
}
