----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    21:45:28 07/26/2012 
-- Design Name: 
-- Module Name:    RAM_MUX - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- Multiplexeur de la memoire du noeud
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
library NocLib ;
--use IEEE.STD_LOGIC_ARITH.ALL;
--use IEEE.STD_LOGIC_UNSIGNED.ALL;
use NocLib.CoreTypes.all;
use work.Packet_type.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
USE ieee.numeric_std.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity RAM_MUX is
    Port ( ram_ena_in : in  STD_LOGIC_VECTOR (1 downto 0);
           ram_enb_in : in  STD_LOGIC_VECTOR (1 downto 0);
           ram_we_in : in  STD_LOGIC_VECTOR (1 downto 0);
           ram_dina_in_0 : in  STD_LOGIC_VECTOR (word - 1 downto 0);
           ram_dina_in_1 : in  STD_LOGIC_VECTOR (word - 1 downto 0);
           ram_addra_in_0 : in  STD_LOGIC_VECTOR (ADRLEN - 1  downto 0);
           ram_addra_in_1 : in  STD_LOGIC_VECTOR (ADRLEN - 1  downto 0);
			  ram_addrb_in_0 : in  STD_LOGIC_VECTOR (ADRLEN - 1  downto 0);
           ram_addrb_in_1 : in  STD_LOGIC_VECTOR (ADRLEN - 1  downto 0);
           ram_dob_in : in  STD_LOGIC_VECTOR (word - 1   downto 0);
          
			  
			  ram_ena_out : out  STD_LOGIC;
           ram_enb_out : out  STD_LOGIC;
           ram_we_out : out  STD_LOGIC;
           ram_dina_out : out  STD_LOGIC_VECTOR (word - 1 downto 0);
           ram_addra_out : out  STD_LOGIC_VECTOR (ADRLEN - 1  downto 0);
   		  ram_addrb_out : out  STD_LOGIC_VECTOR (ADRLEN - 1  downto 0);
           ram_dob_out_0 : out  STD_LOGIC_VECTOR (word - 1   downto 0);
			  ram_dob_out_1 : out  STD_LOGIC_VECTOR (word - 1   downto 0);
			  sel : in std_logic
			  );
end RAM_MUX;

architecture Behavioral of RAM_MUX is

begin

mux : process(sel,ram_ena_in,ram_enb_in ,ram_we_in,ram_dina_in_0, ram_dina_in_1,ram_addra_in_0,ram_addra_in_1, ram_addrb_in_0, ram_addrb_in_1, ram_dob_in)
 begin
      
		  if sel = '1' then
	  -- si sel est  1 les entres 1 sont sur les sorties correspondantes
	        ram_ena_out <= ram_ena_in(1);
           ram_enb_out <= ram_enb_in(1);
           ram_we_out <= ram_we_in(1);
           ram_dina_out <= ram_dina_in_1;
           ram_addra_out <= ram_addra_in_1;
   		  ram_addrb_out <= ram_addrb_in_1 ;
           ram_dob_out_1 <= ram_dob_in;	
           ram_dob_out_0 <= (others => '0');			  
			else 
	  -- si est  0 les entres 0 sont sur les sorties correspondantes
	        ram_ena_out <= ram_ena_in(0);
           ram_enb_out <= ram_enb_in(0);
           ram_we_out <= ram_we_in(0);
           ram_dina_out <= ram_dina_in_0;
           ram_addra_out <= ram_addra_in_0;
   		  ram_addrb_out <= ram_addrb_in_0 ;
			  ram_dob_out_0 <= ram_dob_in;	
           ram_dob_out_1 <= (others => '0');
	 
	 end if;
 
 
 end process;


end Behavioral;

