--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   14:37:10 03/18/2013
-- Design Name:   
-- Module Name:   C:/Core MPI/CORE_MPI/test_DMA.vhd
-- Project Name:  MPI_CORE_COMPONENTS
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: DMA_ARBITER
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--USE ieee.numeric_std.ALL;
 
ENTITY test_DMA IS
END test_DMA;
 
ARCHITECTURE behavior OF test_DMA IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT DMA_ARBITER
    PORT(
         dma_rd_request : IN  std_logic_vector(3 downto 0);
         data_wr_in : IN  std_logic_vector(7 downto 0);
         data_rd_out : OUT  std_logic_vector(7 downto 0);
         address_rd : IN  std_logic_vector(15 downto 0);
         address_wr : IN  std_logic_vector(15 downto 0);
         address_out_wr : OUT  std_logic_vector(15 downto 0);
         address_out_rd : OUT  std_logic_vector(15 downto 0);
         ram_en : OUT  std_logic;
         ram_we : OUT  std_logic;
         data_wr_mem : OUT  std_logic_vector(7 downto 0);
         data_rd_mem : IN  std_logic_vector(7 downto 0);
         dma_wr_grant : OUT  std_logic_vector(3 downto 0);
         hold_req : OUT  std_logic;
         hold_ack : IN  std_logic;
         clk : IN  std_logic;
         reset : IN  std_logic;
         dma_rd_grant : OUT  std_logic_vector(3 downto 0);
         dma_wr_request : IN  std_logic_vector(3 downto 0)
        );
    END COMPONENT;
    
COMPONENT RAM_v
  generic (width : positive;size :positive);
	PORT(
		clka : IN std_logic;
		clkb : IN std_logic;
		wea : IN std_logic;
		ena : IN std_logic;
		enb : IN std_logic;
		addra : IN std_logic_vector;
		addrb : IN std_logic_vector;
		dia : IN std_logic_vector;          
		dob : OUT std_logic_vector
		);
	END COMPONENT;
   --Inputs
   signal dma_rd_request : std_logic_vector(3 downto 0) := (others => '0');
   signal data_wr_in : std_logic_vector(7 downto 0) := (others => '0');
   signal address_rd : std_logic_vector(15 downto 0) := (others => '0');
   signal address_wr : std_logic_vector(15 downto 0) := (others => '0');
   signal data_rd_mem : std_logic_vector(7 downto 0) := (others => '0');
   signal hold_ack : std_logic := '0';
   signal clk : std_logic := '0';
   signal reset : std_logic := '0';
   signal dma_wr_request : std_logic_vector(3 downto 0) := (others => '0');
	
 	--Outputs
   signal data_rd_out : std_logic_vector(7 downto 0);
   signal address_out_wr : std_logic_vector(15 downto 0);
   signal address_out_rd : std_logic_vector(15 downto 0);
   signal ram_en : std_logic;
   signal ram_we : std_logic;
   signal data_wr_mem : std_logic_vector(7 downto 0);
   signal dma_wr_grant : std_logic_vector(3 downto 0);
   signal hold_req : std_logic;
   signal dma_rd_grant : std_logic_vector(3 downto 0);

   -- Clock period definitions
   constant clk_period : time := 10 ns;
 
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: DMA_ARBITER PORT MAP (
          dma_rd_request => dma_rd_request,
          data_wr_in => data_wr_in,
          data_rd_out => data_rd_out,
          address_rd => address_rd,
          address_wr => address_wr,
          address_out_wr => address_out_wr,
          address_out_rd => address_out_rd,
          ram_en => ram_en,
          ram_we => ram_we,
          data_wr_mem => data_wr_mem,
          data_rd_mem => data_rd_mem,
          dma_wr_grant => dma_wr_grant,
          hold_req => hold_req,
          hold_ack => hold_ack,
          clk => clk,
          reset => reset,
          dma_rd_grant => dma_rd_grant,
          dma_wr_request => dma_wr_request
        );

Inst_RAM_v: RAM_v generic map(width=>8,size=>16)
	PORT MAP(
		clka =>clk,
		clkb => clk,
		wea => ram_we,
		ena => ram_en,
		enb => ram_en,
		addra => address_out_wr,
		addrb =>address_out_rd,
		dia => data_wr_mem,
		dob => data_rd_mem 
	);
   -- Clock process definitions
   clk_process :process
   begin
		clk <= '0';
		wait for clk_period/2;
		clk <= '1';
		wait for clk_period/2;
   end process;
 

   -- Stimulus process
   reset_proc: process
   begin		
      -- hold reset state for 100 ns.
		reset <='1';
      wait for 100 ns;	
		reset<='0';
      wait for clk_period*10;
		
      -- insert stimulus here 

      wait;
   end process;
	
	stim_proc: process (clk,reset) 
	variable i,j,k,l : std_logic_vector(15 downto 0);
	variable x: integer ; --indique le temps  partir duquel chaque 
	--permet de faire des requtes DMA et de les valider
   begin	
		if rising_edge(clk) then
			if reset ='1' then 
				x:=0;
			else
				x:=x+1;
				if x>=1 and x<=20 then
				dma_rd_request<="0001";
				elsif x>=21 and x<=40 then
				dma_rd_request<="0011";
				elsif x>=41 and x<=60 then
				dma_rd_request<="0010";
				elsif x>=61 and x<=80 then
				dma_rd_request<="0110";
				elsif x>=81 and x<=100 then
				dma_rd_request<="0100";
				elsif x>=61 and x<=80 then
				dma_rd_request<="1100";
				elsif x>=101 and x<=120 then
				dma_rd_request<="1101";
				elsif x>=121 and x<=140 then
				dma_rd_request<="1001";
				elsif x>=141 and x<=160 then
				dma_rd_request<="1000";
				elsif x>=161 and x<=180 then
				dma_rd_request<="0000";
				elsif x>=181 and x<=200 then
				dma_rd_request<="0111";
				elsif x>=181 and x<=200 then
				dma_rd_request<="1111";
				elsif x>=181 and x<=200 then
				dma_rd_request<="1110";
				else
					x:=0;
				
				end if;
	
			end if;
      end if;
   end process;
stim2_proc: process (clk,reset) 
	variable i,j,k,l : std_logic_vector(15 downto 0);
	variable x: integer ; --indique le temps  partir duquel chaque 
	--permet de faire des requtes DMA et de les valider
   begin	
		if rising_edge(clk) then
			if reset ='1' then 
				x:=0;
			else
				x:=x+1;
				if x>=1 and x<=10 then
				dma_wr_request<="0001";
				elsif x>=11 and x<=20 then
				dma_wr_request<="0011";
				elsif x>=21 and x<=30 then
				dma_wr_request<="0010";
				elsif x>=31 and x<=40 then
				dma_wr_request<="0110";
				elsif x>=41 and x<=50 then
				dma_wr_request<="0100";
				elsif x>=51 and x<=60 then
				dma_wr_request<="1100";
				elsif x>=61 and x<=80 then
				dma_wr_request<="1101";
				elsif x>=81 and x<=90 then
				dma_wr_request<="1001";
				elsif x>=91 and x<=100 then
				dma_wr_request<="1000";
				elsif x>=101 and x<=110 then
				dma_wr_request<="0000";
				elsif x>=111 and x<=120 then
				dma_wr_request<="0111";
				elsif x>=121 and x<=130 then
				dma_wr_request<="1111";
				elsif x>=131 and x<=200 then
				dma_wr_request<="1110";
				else
					x:=0;
				
				end if;
	
			end if;
      end if;
   end process;
liredat:process (dma_rd_grant)
begin


if dma_rd_grant="0001" then
address_rd<=x"0000";
elsif dma_rd_grant="0010" then
address_rd<=x"0002";
elsif dma_rd_grant="0100" then
address_rd<=x"0004";
elsif dma_rd_grant="1000" then
address_rd<=x"0006";
else

 address_rd<=x"0000";
end if;

end process;
ecriredat:process (dma_wr_grant)
begin


if dma_wr_grant="0001" then
address_wr<=x"0000";
data_wr_in<=x"0a";
elsif dma_rd_grant="0010" then
address_wr<=x"0002";
data_wr_in<=x"20";
elsif dma_rd_grant="0100" then
address_wr<=x"0004";
data_wr_in<=x"a0";
elsif dma_rd_grant="1000" then
address_wr<=x"0006";
data_wr_in<=x"0F";
else

 address_wr<=x"0000";
 
end if;

end process;
Hold_ack<=Hold_req; -- toujours autoriser la gestion de la mmoire par le DMA

END;
